/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsTerm;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.ReflectiveIntrospector;
import jade.content.schema.ObjectSchema;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CFReflectiveIntrospector
extends ReflectiveIntrospector {
    protected boolean isAggregateObject(Object slotValue) {
        return slotValue instanceof List || slotValue instanceof Set;
    }

    protected void externaliseAndSetAggregateSlot(AbsObject abs, ObjectSchema schema, String slotName, Object slotValue, ObjectSchema slotSchema, Ontology referenceOnto) throws OntologyException {
        Collection c = (Collection)slotValue;
        if (!c.isEmpty() || schema.isMandatory(slotName)) {
            String aggregateType = null;
            if (slotValue instanceof List) {
                aggregateType = "sequence";
            } else if (slotValue instanceof Set) {
                aggregateType = "set";
            } else {
                throw new OntologyException("Wrong class " + c.getClass().getName() + " for aggregate slot " + slotName + " of object " + abs.getTypeName());
            }
            AbsObject absSlotValue = this.externaliseCollection(c, referenceOnto, aggregateType);
            AbsHelper.setAttribute(abs, slotName, absSlotValue);
        }
    }

    private AbsObject externaliseCollection(Collection c, Ontology referenceOnto, String aggregateType) throws OntologyException {
        AbsAggregate ret = new AbsAggregate(aggregateType);
        try {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ret.add((AbsTerm)referenceOnto.fromObject(it.next()));
            }
        }
        catch (ClassCastException cce) {
            throw new OntologyException("Non term object in aggregate");
        }
        return ret;
    }

    protected Object internaliseAggregateSlot(AbsAggregate absAggregate, Ontology referenceOnto) throws OntologyException {
        Collection c = this.internaliseCollection(absAggregate, referenceOnto);
        return c;
    }

    private Collection internaliseCollection(AbsAggregate absAggregate, Ontology referenceOnto) throws OntologyException {
        AbstractCollection ret = null;
        ret = absAggregate.getTypeName().equals("set") ? new HashSet(absAggregate.size()) : new ArrayList(absAggregate.size());
        int i = 0;
        while (i < absAggregate.size()) {
            Object element = referenceOnto.toObject(absAggregate.get(i));
            Ontology.checkIsTerm(element);
            ret.add(element);
            ++i;
        }
        return ret;
    }
}

