/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.ContainerID;
import jade.core.NotFoundException;
import jade.mtp.MTPDescriptor;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;

class ContainerTable {
    private static final int CONTAINERS_SIZE = 10;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Map entries = new HashMap(10);

    ContainerTable() {
    }

    public synchronized void addContainer(ContainerID cid) {
        Entry e = new Entry();
        this.entries.put(cid, e);
    }

    public synchronized void addMTP(ContainerID cid, MTPDescriptor mtp) throws NotFoundException {
        Entry e = (Entry)this.entries.get(cid);
        if (e == null) {
            throw new NotFoundException("No container named " + cid.getName() + " was found.");
        }
        List l = e.getMTPs();
        l.add(mtp);
    }

    public synchronized void removeContainer(ContainerID cid) {
        this.entries.remove(cid);
        this.notifyAll();
    }

    public synchronized void removeMTP(ContainerID cid, MTPDescriptor mtp) throws NotFoundException {
        Entry e = (Entry)this.entries.get(cid);
        if (e == null) {
            throw new NotFoundException("No container named " + cid.getName() + " was found.");
        }
        List l = e.getMTPs();
        l.remove(mtp);
    }

    public synchronized List getMTPs(ContainerID cid) throws NotFoundException {
        Entry e = (Entry)this.entries.get(cid);
        if (e == null) {
            throw new NotFoundException("No container named " + cid.getName() + " was found.");
        }
        return e.getMTPs();
    }

    public int size() {
        return this.entries.size();
    }

    public synchronized ContainerID[] names() {
        ContainerID[] result = new ContainerID[this.entries.size()];
        Iterator it = this.entries.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i++] = (ContainerID)it.next();
        }
        return result;
    }

    synchronized boolean waitForRemoval(ContainerID cid, long timeout) {
        try {
            while (this.entries.containsKey(cid)) {
                this.wait(timeout);
                if (!this.entries.containsKey(cid)) continue;
                this.myLogger.log(Logger.WARNING, "Container " + cid.getName() + " did not terminate when requested to do so.");
                return false;
            }
        }
        catch (InterruptedException ie) {
            this.myLogger.log(Logger.WARNING, "Interrupted while waiting for container " + cid.getName() + " termination");
            return false;
        }
        return true;
    }

    synchronized boolean waitUntilEmpty(long timeout) {
        long time = System.currentTimeMillis();
        long deadline = time + timeout;
        try {
            while (!this.entries.isEmpty()) {
                if (timeout > 0L && time >= deadline) {
                    this.myLogger.log(Logger.WARNING, "Some entries still present in container table");
                    break;
                }
                this.wait(deadline - time);
                time = System.currentTimeMillis();
            }
        }
        catch (InterruptedException ie) {
            this.myLogger.log(Logger.WARNING, "Interrupted while waiting for container table to be empty");
        }
        return this.entries.isEmpty();
    }

    private static class Entry {
        private List mtps = new LinkedList();

        public void addMTP(MTPDescriptor mtp) {
            this.mtps.add(mtp);
        }

        public void removeMTP(MTPDescriptor mtp) {
            this.mtps.remove(mtp);
        }

        public List getMTPs() {
            return this.mtps;
        }
    }
}

