/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.behaviours.Behaviour;
import jade.util.leap.LinkedList;
import jade.util.leap.Serializable;

class BehaviourList
extends LinkedList
implements Serializable {
    private int current = 0;

    BehaviourList() {
    }

    public synchronized void addElement(Behaviour b) {
        this.add(b);
    }

    public synchronized boolean removeElement(Behaviour b) {
        int index = this.indexOf(b);
        if (index != -1) {
            this.remove(b);
            if (index < this.current) {
                --this.current;
            } else if (index == this.current && this.current == this.size()) {
                this.current = 0;
            }
        }
        return index != -1;
    }

    public Behaviour getCurrent() {
        Behaviour b = null;
        try {
            b = (Behaviour)this.get(this.current);
        }
        catch (IndexOutOfBoundsException ioobe) {}
        return b;
    }

    public synchronized void begin() {
        this.current = 0;
    }

    private boolean currentIsLast() {
        return this.current == this.size() - 1;
    }

    public synchronized Behaviour next() {
        this.current = this.currentIsLast() || this.isEmpty() ? 0 : ++this.current;
        return this.getCurrent();
    }
}

