/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SubscriptionResponder
extends FSMBehaviour
implements FIPANames.InteractionProtocol {
    public final String SUBSCRIPTION_KEY;
    public final String CANCEL_KEY;
    public final String RESPONSE_KEY;
    private static final String RECEIVE_SUBSCRIPTION = "Receive-subscription";
    private static final String HANDLE_SUBSCRIPTION = "Handle-subscription";
    private static final String HANDLE_CANCEL = "Handle-cancel";
    private static final String SEND_RESPONSE = "Send-response";
    private static final String SEND_NOTIFICATIONS = "Send-notifications";
    private MsgReceiver msgRecBehaviour;
    private Hashtable subscriptions;
    private List notifications;
    protected SubscriptionManager mySubscriptionManager;

    public static MessageTemplate createMessageTemplate(int perf) {
        return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-subscribe"), MessageTemplate.or(MessageTemplate.MatchPerformative(perf), MessageTemplate.MatchPerformative(2)));
    }

    public SubscriptionResponder(Agent a, MessageTemplate mt) {
        this(a, mt, null, new DataStore());
    }

    public SubscriptionResponder(Agent a, MessageTemplate mt, SubscriptionManager sm) {
        this(a, mt, sm, new DataStore());
    }

    public SubscriptionResponder(Agent a, MessageTemplate mt, SubscriptionManager sm, DataStore store) {
        super(a);
        this.CANCEL_KEY = this.SUBSCRIPTION_KEY = "__subs_canc" + this.hashCode();
        this.RESPONSE_KEY = "__response" + this.hashCode();
        this.msgRecBehaviour = null;
        this.subscriptions = new Hashtable();
        this.notifications = new ArrayList();
        this.mySubscriptionManager = null;
        this.setDataStore(store);
        this.mySubscriptionManager = sm;
        this.registerDefaultTransition(RECEIVE_SUBSCRIPTION, HANDLE_SUBSCRIPTION);
        this.registerTransition(RECEIVE_SUBSCRIPTION, HANDLE_CANCEL, 2);
        this.registerTransition(RECEIVE_SUBSCRIPTION, SEND_NOTIFICATIONS, -1002);
        this.registerDefaultTransition(HANDLE_SUBSCRIPTION, SEND_RESPONSE);
        this.registerDefaultTransition(HANDLE_CANCEL, SEND_RESPONSE);
        this.registerDefaultTransition(SEND_RESPONSE, RECEIVE_SUBSCRIPTION, new String[]{HANDLE_SUBSCRIPTION, HANDLE_CANCEL});
        this.registerDefaultTransition(SEND_NOTIFICATIONS, RECEIVE_SUBSCRIPTION);
        OneShotBehaviour b = null;
        this.msgRecBehaviour = new MsgReceiver(this.myAgent, mt, -1L, this.getDataStore(), this.SUBSCRIPTION_KEY);
        this.registerFirstState(this.msgRecBehaviour, RECEIVE_SUBSCRIPTION);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                DataStore ds = this.getDataStore();
                ACLMessage subscription = (ACLMessage)ds.get(SubscriptionResponder.this.SUBSCRIPTION_KEY);
                ACLMessage response = null;
                try {
                    response = SubscriptionResponder.this.handleSubscription(subscription);
                }
                catch (NotUnderstoodException nue) {
                    response = nue.getACLMessage();
                }
                catch (RefuseException re) {
                    response = re.getACLMessage();
                }
                ds.put(SubscriptionResponder.this.RESPONSE_KEY, response);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_SUBSCRIPTION);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                DataStore ds = this.getDataStore();
                ACLMessage cancel = (ACLMessage)ds.get(SubscriptionResponder.this.CANCEL_KEY);
                ACLMessage response = null;
                try {
                    response = SubscriptionResponder.this.handleCancel(cancel);
                }
                catch (FailureException fe) {
                    response = fe.getACLMessage();
                }
                ds.put(SubscriptionResponder.this.RESPONSE_KEY, response);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_CANCEL);
        b = new ReplySender(this.myAgent, this.RESPONSE_KEY, this.SUBSCRIPTION_KEY);
        b.setDataStore(this.getDataStore());
        this.registerState(b, SEND_RESPONSE);
        b = new OneShotBehaviour(this.myAgent){

            public void action() {
                SubscriptionResponder.this.sendNotifications();
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, SEND_NOTIFICATIONS);
    }

    public void reset() {
        super.reset();
        DataStore ds = this.getDataStore();
        ds.remove(this.SUBSCRIPTION_KEY);
        ds.remove(this.RESPONSE_KEY);
    }

    public void reset(MessageTemplate mt) {
        this.reset();
        this.msgRecBehaviour.reset(mt, -1L, this.getDataStore(), this.SUBSCRIPTION_KEY);
    }

    protected ACLMessage handleSubscription(ACLMessage subscription) throws NotUnderstoodException, RefuseException {
        return this.prepareResponse(subscription);
    }

    protected ACLMessage prepareResponse(ACLMessage subscription) throws NotUnderstoodException, RefuseException {
        Subscription subs = this.createSubscription(subscription);
        if (this.mySubscriptionManager != null) {
            this.mySubscriptionManager.register(subs);
        }
        return null;
    }

    protected ACLMessage handleCancel(ACLMessage cancel) throws FailureException {
        Subscription s = this.getSubscription(cancel);
        if (s != null) {
            if (this.mySubscriptionManager != null) {
                this.mySubscriptionManager.deregister(s);
            }
            s.close();
        }
        return null;
    }

    public void registerHandleSubscription(Behaviour b) {
        this.registerState(b, HANDLE_SUBSCRIPTION);
        b.setDataStore(this.getDataStore());
    }

    public void registerPrepareResponse(Behaviour b) {
        this.registerHandleSubscription(b);
    }

    public void registerHandleCancel(Behaviour b) {
        this.registerState(b, HANDLE_CANCEL);
        b.setDataStore(this.getDataStore());
    }

    public Subscription createSubscription(ACLMessage subsMsg) {
        Subscription s = new Subscription(this, subsMsg);
        String convId = subsMsg.getConversationId();
        if (convId != null) {
            this.subscriptions.put(convId, s);
        }
        return s;
    }

    public Subscription getSubscription(ACLMessage msg) {
        String convId = msg.getConversationId();
        return this.getSubscription(convId);
    }

    public Subscription getSubscription(String convId) {
        Subscription s = null;
        if (convId != null) {
            s = (Subscription)this.subscriptions.get(convId);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSubscriptions(AID subscriber) {
        Hashtable hashtable = this.subscriptions;
        synchronized (hashtable) {
            Vector<Subscription> ss = new Vector<Subscription>();
            Enumeration en = this.subscriptions.elements();
            while (en.hasMoreElements()) {
                Subscription s = (Subscription)en.nextElement();
                if (!s.getMessage().getSender().equals(subscriber)) continue;
                ss.addElement(s);
            }
            return ss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSubscriptions() {
        Hashtable hashtable = this.subscriptions;
        synchronized (hashtable) {
            Vector<Subscription> ss = new Vector<Subscription>();
            Enumeration en = this.subscriptions.elements();
            while (en.hasMoreElements()) {
                Subscription s = (Subscription)en.nextElement();
                ss.addElement(s);
            }
            return ss;
        }
    }

    private synchronized void addNotification(ACLMessage notification, ACLMessage subscription) {
        ACLMessage[] tmp = new ACLMessage[]{notification, subscription};
        this.notifications.add(tmp);
        this.msgRecBehaviour.interrupt();
    }

    private synchronized void sendNotifications() {
        Iterator it = this.notifications.iterator();
        while (it.hasNext()) {
            boolean receiversNull = true;
            boolean replyWithNull = true;
            ACLMessage[] tmp = (ACLMessage[])it.next();
            if (tmp[0].getAllReceiver().hasNext()) {
                receiversNull = false;
            }
            if (tmp[0].getReplyWith() != null) {
                replyWithNull = false;
            }
            ReplySender.adjustReply(this.myAgent, tmp[0], tmp[1]);
            this.myAgent.send(tmp[0]);
            if (receiversNull) {
                tmp[0].clearAllReceiver();
            }
            if (!replyWithNull) continue;
            tmp[0].setReplyWith(null);
        }
        this.notifications.clear();
    }

    public static class Subscription {
        private ACLMessage subscription;
        private SubscriptionResponder myResponder;

        private Subscription(SubscriptionResponder r, ACLMessage s) {
            this.myResponder = r;
            this.subscription = s;
        }

        public ACLMessage getMessage() {
            return this.subscription;
        }

        public void notify(ACLMessage notification) {
            this.myResponder.addNotification(notification, this.subscription);
        }

        public void close() {
            String convId = this.subscription.getConversationId();
            if (convId != null) {
                this.myResponder.subscriptions.remove(convId);
            }
        }
    }

    public static interface SubscriptionManager {
        public boolean register(Subscription var1) throws RefuseException, NotUnderstoodException;

        public boolean deregister(Subscription var1) throws FailureException;
    }
}

