/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.Location;
import jade.core.NotFoundException;
import jade.wrapper.AgentController;
import jade.wrapper.AgentState;
import jade.wrapper.ContainerProxy;
import jade.wrapper.StaleProxyException;
import jade.wrapper.State;

class AgentControllerImpl
implements AgentController {
    private AID agentID;
    private ContainerProxy myProxy;
    private AgentContainer myContainer;

    public AgentControllerImpl(AID id, ContainerProxy cp, AgentContainer ac) {
        this.agentID = id;
        this.myProxy = cp;
        this.myContainer = ac;
    }

    public String getName() throws StaleProxyException {
        Agent a = this.myContainer.acquireLocalAgent(this.agentID);
        if (a == null) {
            throw new StaleProxyException("Controlled agent not found");
        }
        this.myContainer.releaseLocalAgent(this.agentID);
        return this.agentID.getName();
    }

    public void start() throws StaleProxyException {
        try {
            this.myContainer.powerUpLocalAgent(this.agentID);
        }
        catch (NotFoundException nfe) {
            throw new StaleProxyException("Controlled agent not found");
        }
    }

    public void suspend() throws StaleProxyException {
        try {
            this.myProxy.suspendAgent(this.agentID);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public void activate() throws StaleProxyException {
        try {
            this.myProxy.activateAgent(this.agentID);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public void kill() throws StaleProxyException {
        try {
            this.myProxy.killAgent(this.agentID);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public void move(Location where) throws StaleProxyException {
        try {
            this.myProxy.moveAgent(this.agentID, where);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public void clone(Location where, String newName) throws StaleProxyException {
        try {
            this.myProxy.cloneAgent(this.agentID, where, newName);
        }
        catch (Throwable t) {
            throw new StaleProxyException(t);
        }
    }

    public void putO2AObject(Object o, boolean blocking) throws StaleProxyException {
        Agent adaptee = this.myContainer.acquireLocalAgent(this.agentID);
        if (adaptee == null) {
            throw new StaleProxyException("Controlled agent does not exist");
        }
        try {
            adaptee.putO2AObject(o, blocking);
        }
        catch (InterruptedException ace) {
            throw new StaleProxyException(ace);
        }
        this.myContainer.releaseLocalAgent(this.agentID);
    }

    public State getState() throws StaleProxyException {
        Agent adaptee = this.myContainer.acquireLocalAgent(this.agentID);
        if (adaptee == null) {
            throw new StaleProxyException("Controlled agent does not exist");
        }
        int jadeState = adaptee.getState();
        State ret = null;
        switch (jadeState) {
            case 1: {
                ret = AgentState.AGENT_STATE_INITIATED;
                break;
            }
            case 2: {
                ret = AgentState.AGENT_STATE_ACTIVE;
                break;
            }
            case 3: {
                ret = AgentState.AGENT_STATE_IDLE;
                break;
            }
            case 4: {
                ret = AgentState.AGENT_STATE_SUSPENDED;
                break;
            }
            case 5: {
                ret = AgentState.AGENT_STATE_WAITING;
                break;
            }
            case 6: {
                ret = AgentState.AGENT_STATE_DELETED;
                break;
            }
            default: {
                throw new InternalError("Unknown state: " + jadeState);
            }
        }
        this.myContainer.releaseLocalAgent(this.agentID);
        return ret;
    }
}

