/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ToFrontWindowFocusListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.WindowTransparencyListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ContentDialog
extends JDialog {
    protected Content content;
    protected ContentUI contentUI;

    public ContentDialog(ResourceManager resourceManager, Content content, ContentUI contentUI, Frame parentFrame, Rectangle inBounds) throws HeadlessException {
        super(resourceManager.getBoolean("dialog.owner.enabled", true) ? parentFrame : null, false);
        Rectangle detachedBounds;
        this.content = content;
        this.contentUI = contentUI;
        Component component = content.getComponent();
        component.setPreferredSize(component.getSize());
        this.setTitle(content.getTitle());
        this.getContentPane().setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        this.getContentPane().add(component, "0,0,FULL,FULL");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new ContentDialogWindowAdapter());
        if (parentFrame == null) {
            this.addWindowFocusListener(new ToFrontWindowFocusListener(this));
        }
        this.addComponentListener(new ContentDialogComponentAdapter());
        if (resourceManager.getTransparencyManager().isServiceAvailable()) {
            WindowTransparencyListener windowTransparencyListener = new WindowTransparencyListener(resourceManager.getTransparencyManager(), contentUI, this);
            this.addWindowListener(windowTransparencyListener);
            this.addWindowFocusListener(windowTransparencyListener);
        }
        if ((detachedBounds = SwingUtil.validateBounds(contentUI.getDetachedBounds())) != null) {
            this.setBounds(detachedBounds);
        } else if (inBounds != null) {
            this.setBounds(inBounds);
        } else if (parentFrame != null) {
            Point location = parentFrame.getLocation();
            location.translate(5, 5);
            this.setLocation(location);
        } else {
            SwingUtil.centrePositionOnScreen(this);
        }
    }

    public void dispose() {
        super.dispose();
        this.content = null;
        this.contentUI = null;
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void setLocation(Point p) {
        super.setLocation(p);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        System.out.println("setBounds r = " + r);
        super.setBounds(r);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    public void setSize(Dimension d) {
        super.setSize(d);
    }

    protected class ContentDialogComponentAdapter
    extends ComponentAdapter {
        protected ContentDialogComponentAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            if (ContentDialog.this.isActive() && ContentDialog.this.isVisible()) {
                System.out.println("componentResized getBounds() = " + ContentDialog.this.getBounds());
                ContentDialog.this.contentUI.setDetachedBounds(ContentDialog.this.getBounds());
            }
        }

        public void componentMoved(ComponentEvent e) {
            if (ContentDialog.this.isActive() && ContentDialog.this.isVisible()) {
                System.out.println("componentMoved getBounds() = " + ContentDialog.this.getBounds());
                ContentDialog.this.contentUI.setDetachedBounds(ContentDialog.this.getBounds());
            }
        }
    }

    protected class ContentDialogWindowAdapter
    extends WindowAdapter {
        protected ContentDialogWindowAdapter() {
        }

        public void windowClosing(WindowEvent event) {
            ContentDialog.this.content.setDetached(false);
        }
    }
}

