/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.core.AgentState;
import jade.tools.introspector.gui.MainBarListener;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class StatePanel
extends JPanel {
    private int state;
    private ButtonGroup leds;
    private JRadioButton waitingLed;
    private JRadioButton activeLed;
    private JRadioButton suspendedLed;
    private JRadioButton deletedLed;
    private JRadioButton movingLed;
    private JRadioButton idleLed;
    private JButton suspendAction;
    private JButton waitAction;
    private JButton wakeUpAction;
    private JButton killAction;
    private Icon ledOff = new ImageIcon(this.getClass().getResource("images/rbs.gif"));
    private Icon ledOn = new ImageIcon(this.getClass().getResource("images/rbrs.gif"));
    private Icon button = new ImageIcon(this.getClass().getResource("images/rb.gif"));
    private Icon pressedButton = new ImageIcon(this.getClass().getResource("images/rbp.gif"));
    private Font myFont = new Font("Monospaced", 1, 10);
    private MainBarListener listener;
    private Map ledMap = new HashMap();

    public StatePanel(MainBarListener list) {
        this.leds = new ButtonGroup();
        this.listener = list;
        this.build();
    }

    public void build() {
        Border line = BorderFactory.createEtchedBorder();
        JPanel ledPanel = new JPanel();
        ledPanel.setLayout(new BoxLayout(ledPanel, 1));
        ledPanel.setAlignmentX(0.5f);
        ledPanel.setBorder(BorderFactory.createTitledBorder(line, "Current State", 2, 2, new Font("Dialog", 1, 10)));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setAlignmentX(0.5f);
        buttonPanel.setBorder(BorderFactory.createTitledBorder(line, "Change State", 2, 2, new Font("Dialog", 1, 10)));
        this.activeLed = new JRadioButton("Active", this.ledOff);
        this.activeLed.setFont(this.myFont);
        this.activeLed.setAlignmentX(0.0f);
        this.activeLed.setDisabledSelectedIcon(this.ledOn);
        this.activeLed.setDisabledIcon(this.ledOff);
        this.activeLed.setEnabled(false);
        this.leds.add(this.activeLed);
        this.ledMap.put(AgentState.getInstance((int)2), this.activeLed);
        ledPanel.add(this.activeLed);
        this.suspendedLed = new JRadioButton("Suspended", this.ledOff);
        this.suspendedLed.setFont(this.myFont);
        this.suspendedLed.setAlignmentX(0.0f);
        this.suspendedLed.setDisabledSelectedIcon(this.ledOn);
        this.suspendedLed.setDisabledIcon(this.ledOff);
        this.suspendedLed.setEnabled(false);
        this.leds.add(this.suspendedLed);
        this.ledMap.put(AgentState.getInstance((int)4), this.suspendedLed);
        ledPanel.add(this.suspendedLed);
        this.idleLed = new JRadioButton("Idle", this.ledOff);
        this.idleLed.setFont(this.myFont);
        this.idleLed.setAlignmentX(0.0f);
        this.idleLed.setDisabledSelectedIcon(this.ledOn);
        this.idleLed.setDisabledIcon(this.ledOff);
        this.idleLed.setEnabled(false);
        this.leds.add(this.idleLed);
        this.ledMap.put(AgentState.getInstance((int)3), this.idleLed);
        ledPanel.add(this.idleLed);
        this.waitingLed = new JRadioButton("Waiting", this.ledOff);
        this.waitingLed.setFont(this.myFont);
        this.waitingLed.setAlignmentX(0.0f);
        this.waitingLed.setDisabledSelectedIcon(this.ledOn);
        this.waitingLed.setDisabledIcon(this.ledOff);
        this.waitingLed.setEnabled(false);
        this.leds.add(this.waitingLed);
        this.ledMap.put(AgentState.getInstance((int)5), this.waitingLed);
        ledPanel.add(this.waitingLed);
        this.movingLed = new JRadioButton("Moving", this.ledOff);
        this.movingLed.setFont(this.myFont);
        this.movingLed.setAlignmentX(0.0f);
        this.movingLed.setDisabledSelectedIcon(this.ledOn);
        this.movingLed.setDisabledIcon(this.ledOff);
        this.movingLed.setEnabled(false);
        this.leds.add(this.movingLed);
        this.ledMap.put(AgentState.getInstance((int)7), this.movingLed);
        ledPanel.add(this.movingLed);
        this.deletedLed = new JRadioButton("Dead", this.ledOff);
        this.deletedLed.setFont(this.myFont);
        this.deletedLed.setAlignmentX(0.0f);
        this.deletedLed.setDisabledSelectedIcon(this.ledOn);
        this.deletedLed.setDisabledIcon(this.ledOff);
        this.deletedLed.setEnabled(false);
        this.leds.add(this.deletedLed);
        this.ledMap.put(AgentState.getInstance((int)6), this.deletedLed);
        ledPanel.add(this.deletedLed);
        this.suspendAction = new JButton("Suspend", this.button);
        this.configurePushButton(this.suspendAction);
        this.suspendAction.setMnemonic(5);
        this.waitAction = new JButton("Wait", this.button);
        this.configurePushButton(this.waitAction);
        this.waitAction.setMnemonic(7);
        this.wakeUpAction = new JButton("Wake Up", this.button);
        this.configurePushButton(this.wakeUpAction);
        this.wakeUpAction.setMnemonic(6);
        this.killAction = new JButton("Kill", this.button);
        this.configurePushButton(this.killAction);
        this.killAction.setMnemonic(4);
        buttonPanel.add(this.suspendAction);
        buttonPanel.add(this.waitAction);
        buttonPanel.add(this.wakeUpAction);
        buttonPanel.add(this.killAction);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(15));
        this.add(ledPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(buttonPanel);
    }

    public void switchTo(AgentState as) {
        JRadioButton led = (JRadioButton)this.ledMap.get(as);
        if (led != null) {
            led.setSelected(true);
        }
    }

    private void configureLED(JRadioButton led) {
    }

    private void configurePushButton(JButton but) {
        but.setPressedIcon(this.pressedButton);
        but.setBorderPainted(false);
        but.setFocusPainted(false);
        but.setBorder(BorderFactory.createEmptyBorder());
        but.setAlignmentX(0.0f);
        but.setFont(this.myFont);
        but.addActionListener(this.listener);
    }
}

