/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.core.AID;
import jade.core.ContainerID;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.JADEAgentManagement.InstallMTP;
import jade.domain.JADEAgentManagement.UninstallMTP;
import jade.gui.APDescriptionPanel;
import jade.gui.AclGui;
import jade.gui.AgentTreeModel;
import jade.lang.acl.ACLMessage;
import jade.tools.rma.ActionProcessor;
import jade.tools.rma.InstallMTPDialog;
import jade.tools.rma.MainMenu;
import jade.tools.rma.MainPanel;
import jade.tools.rma.ManageMTPsDialog;
import jade.tools.rma.PopupMenuAgent;
import jade.tools.rma.PopupMenuContainer;
import jade.tools.rma.PopupMenuFrozenAgent;
import jade.tools.rma.PopupMenuPlatform;
import jade.tools.rma.PopupMenuRemotePlatform;
import jade.tools.rma.RMAAction;
import jade.tools.rma.ToolBar;
import jade.tools.rma.WindowCloser;
import jade.tools.rma.rma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class MainWindow
extends JFrame {
    private MainPanel tree;
    private ActionProcessor actPro;
    private PopupMenuAgent popA;
    private PopupMenuFrozenAgent popFA;
    private PopupMenuContainer popC;
    private PopupMenuPlatform popP;
    private PopupMenuRemotePlatform popRP;
    private InstallMTPDialog installDlg = new InstallMTPDialog((Frame)this, true);
    private ManageMTPsDialog manageDlg;
    private String logojade = "images/logosmall.jpg";
    private List containerNames = new LinkedList();
    private Map addresses = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public MainWindow(rma anRMA) {
        super(anRMA.getName() + " - JADE Remote Agent Management GUI");
        this.manageDlg = new ManageMTPsDialog(anRMA, this, false, this.addresses);
        this.tree = new MainPanel(anRMA, this);
        this.actPro = new ActionProcessor(anRMA, this, this.tree);
        this.setJMenuBar(new MainMenu(this, this.actPro));
        this.popA = new PopupMenuAgent(this.actPro);
        this.popFA = new PopupMenuFrozenAgent(this.actPro);
        this.popC = new PopupMenuContainer(this.actPro);
        this.popP = new PopupMenuPlatform(this.actPro);
        this.popRP = new PopupMenuRemotePlatform(this.actPro);
        this.tree.treeAgent.setNewPopupMenu("FIPAAGENT", this.popA);
        this.tree.treeAgent.setNewPopupMenu("FROZENAGENT", this.popFA);
        this.tree.treeAgent.setNewPopupMenu("FIPACONTAINER", this.popC);
        this.tree.treeAgent.setNewPopupMenu("REMOTEPLATFORM", this.popRP);
        JPopupMenu popupRemote = new JPopupMenu();
        JMenuItem temp = popupRemote.add((RMAAction)ActionProcessor.actions.get("Custom Agent"));
        temp.setIcon(null);
        temp = popupRemote.add((RMAAction)ActionProcessor.actions.get("Register Remote Agent with local AMS"));
        temp.setIcon(null);
        temp.setEnabled(false);
        this.tree.treeAgent.setNewPopupMenu("REMOTEAGENT", popupRemote);
        this.tree.treeAgent.setNewPopupMenu("SUPERCONTAINER", this.popP);
        JPopupMenu popLocalPlatform = new JPopupMenu();
        JMenuItem tmp = popLocalPlatform.add((RMAAction)ActionProcessor.actions.get("View AP Description"));
        tmp.setIcon(null);
        popLocalPlatform.add((RMAAction)ActionProcessor.actions.get("Manage Installed MTPs"));
        this.tree.treeAgent.setNewPopupMenu("LOCALPLATFORM", popLocalPlatform);
        this.setForeground(Color.black);
        this.setBackground(Color.lightGray);
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.logojade));
        this.setIconImage(image);
        this.addWindowListener(new WindowCloser(anRMA));
        this.getContentPane().add((Component)new ToolBar(this.tree, this, this.actPro), "North");
        this.getContentPane().add((Component)this.tree, "Center");
    }

    public void ShowCorrect() {
        this.pack();
        this.setSize(600, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int centerX = (int)screenSize.getWidth() / 2;
        int centerY = (int)screenSize.getHeight() / 2;
        this.setLocation(centerX - 300, centerY - 200);
        this.tree.adjustDividersLocation();
        this.setVisible(true);
        this.toFront();
    }

    public void disposeAsync() {
        final MainWindow toDispose = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                toDispose.dispose();
            }
        });
    }

    public AgentTreeModel getModel() {
        return this.tree.treeAgent.getModel();
    }

    public void resetTree() {
        Runnable resetIt = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.clearLocalPlatform();
            }
        };
        SwingUtilities.invokeLater(resetIt);
    }

    public void addContainer(final String name, final InetAddress addr) {
        Runnable addIt = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.addContainerNode(name, addr);
                MainWindow.this.containerNames.add(name);
                MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeContainer(final String name) {
        Runnable removeIt = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.removeContainerNode(name);
                MainWindow.this.containerNames.remove(name);
                MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
            }
        };
        SwingUtilities.invokeLater(removeIt);
    }

    public void addAgent(final String containerName, final AID agentID, final String state, final String ownership) {
        Runnable addIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                jade.util.leap.Iterator add = agentID.getAllAddresses();
                String agentAddresses = "";
                while (add.hasNext()) {
                    agentAddresses = agentAddresses + add.next() + " ";
                }
                ((MainWindow)MainWindow.this).tree.treeAgent.addAgentNode(agentName, agentAddresses, containerName, state, ownership);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeAgent(final String containerName, final AID agentID) {
        Runnable removeIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.removeAgentNode(containerName, agentName);
            }
        };
        SwingUtilities.invokeLater(removeIt);
    }

    public void modifyAgent(final String containerName, final AID agentID, final String state, final String ownership) {
        Runnable modifyIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.modifyAgentNode(containerName, agentName, null, state, ownership);
            }
        };
        SwingUtilities.invokeLater(modifyIt);
    }

    public void moveAgent(final String fromContainer, final String toContainer, final AID agentID) {
        Runnable moveIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.moveAgentNode(fromContainer, toContainer, agentName);
            }
        };
        SwingUtilities.invokeLater(moveIt);
    }

    public void modifyFrozenAgent(final String oldContainer, final String newContainer, final AID agentID) {
        Runnable freezeIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.freezeAgentNode(oldContainer, newContainer, agentName);
            }
        };
        SwingUtilities.invokeLater(freezeIt);
    }

    public void modifyThawedAgent(final String oldContainer, final String newContainer, final AID agentID) {
        Runnable thawIt = new Runnable(){

            public void run() {
                String agentName = agentID.getName();
                ((MainWindow)MainWindow.this).tree.treeAgent.thawAgentNode(oldContainer, newContainer, agentName);
            }
        };
        SwingUtilities.invokeLater(thawIt);
    }

    public void addAddress(final String address, final String where) {
        Runnable addIt = new Runnable(){

            public void run() {
                LinkedList<String> addrs = (LinkedList<String>)MainWindow.this.addresses.get(where);
                if (addrs == null) {
                    addrs = new LinkedList<String>();
                    MainWindow.this.addresses.put(where, addrs);
                }
                addrs.add(address);
                MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void addRemotePlatformFolder() {
        Runnable addIt = new Runnable(){

            public void run() {
                PopupMenuPlatform menu = new PopupMenuPlatform(MainWindow.this.actPro);
                ((MainWindow)MainWindow.this).tree.treeAgent.setNewPopupMenu("REMOTEPLATFORMS", menu);
                ((MainWindow)MainWindow.this).tree.treeAgent.addRemotePlatformsFolderNode();
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void addRemotePlatform(AID name, APDescription profile) {
        final APDescription desc = profile;
        final AID ams = name;
        Runnable addIt = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.addRemotePlatformNode(ams, desc);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void addRemoteAgentsToRemotePlatform(final APDescription platform, final Iterator i) {
        Runnable addIt = new Runnable(){

            public void run() {
                while (i.hasNext()) {
                    AMSAgentDescription agent = (AMSAgentDescription)i.next();
                    ((MainWindow)MainWindow.this).tree.treeAgent.addRemoteAgentNode(agent, platform.getName());
                }
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeRemotePlatform(final String platformName) {
        Runnable addIt = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.removeRemotePlatformNode(platformName);
            }
        };
        SwingUtilities.invokeLater(addIt);
    }

    public void removeAddress(final String address, final String where) {
        Runnable removeIt = new Runnable(){

            public void run() {
                List addrs = (List)MainWindow.this.addresses.get(where);
                if (addrs != null) {
                    addrs.remove(address);
                    if (addrs.isEmpty()) {
                        MainWindow.this.addresses.remove(where);
                    }
                    MainWindow.this.manageDlg.setData(MainWindow.this.containerNames, MainWindow.this.addresses);
                }
            }
        };
        SwingUtilities.invokeLater(removeIt);
    }

    public void refreshLocalPlatformName(final String name) {
        Runnable refreshName = new Runnable(){

            public void run() {
                ((MainWindow)MainWindow.this).tree.treeAgent.refreshLocalPlatformName(name);
            }
        };
        SwingUtilities.invokeLater(refreshName);
    }

    public void showErrorDialog(String text, ACLMessage msg) {
        String[] messages = new String[]{text, "", "Do you want to view the ACL message ?"};
        int answer = JOptionPane.showConfirmDialog(this, messages, "RMA Error !!!", 0, 0);
        switch (answer) {
            case 0: {
                AclGui.showMsgInDialog(msg, this);
                break;
            }
        }
    }

    public boolean showExitDialog(String message) {
        int n = JOptionPane.showConfirmDialog(this, "Are you really sure to exit ?", message, 0);
        return n == 0;
    }

    public boolean showInstallMTPDialog(InstallMTP imtp) {
        String[] names = this.containerNames.toArray(new String[0]);
        this.installDlg.reset(names, imtp.getContainer().getName());
        this.installDlg.pack();
        this.installDlg.setVisible(true);
        imtp.setContainer(new ContainerID(this.installDlg.getContainer(), null));
        imtp.setAddress(this.installDlg.getAddress());
        imtp.setClassName(this.installDlg.getClassName());
        return this.installDlg.isConfirmed();
    }

    public boolean showUninstallMTPDialog(UninstallMTP umtp) {
        String where = umtp.getContainer().getName();
        List addrs = (List)this.addresses.get(where);
        if (addrs == null) {
            JOptionPane.showMessageDialog(this, "No MTPs are currently installed on this container.", "Error during MTP removal", 0);
            return false;
        }
        Object[] names = addrs.toArray();
        String address = (String)JOptionPane.showInputDialog(this, "Choose the MTP to remove.", "Remove an MTP", 1, null, names, names[0]);
        if (address != null) {
            umtp.setAddress(address);
            return true;
        }
        return false;
    }

    public void showManageMTPsDialog() {
        this.manageDlg.showCentered();
    }

    public void viewAPDescriptionDialog(APDescription ap, String title) {
        if (ap != null) {
            APDescriptionPanel.showAPDescriptionInDialog(ap, this, title);
        }
    }

    private void setUI(String ui) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf." + ui);
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    public void setUI2Motif() {
        this.setUI("motif.MotifLookAndFeel");
    }

    public void setUI2Windows() {
        this.setUI("windows.WindowsLookAndFeel");
    }

    public void setUI2Multi() {
        this.setUI("multi.MultiLookAndFeel");
    }

    public void setUI2Metal() {
        this.setUI("metal.MetalLookAndFeel");
    }
}

