/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.testagent;

import jade.Boot;
import jade.content.AgentAction;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.tools.testagent.ReceiveCyclicBehaviour;
import jade.tools.testagent.TestAgentFrame;
import jade.util.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class TestAgent
extends Agent {
    private static Logger logger = Logger.getMyLogger((String)(class$jade$tools$testagent$TestAgent == null ? (class$jade$tools$testagent$TestAgent = TestAgent.class$("jade.tools.testagent.TestAgent")) : class$jade$tools$testagent$TestAgent).getName());
    boolean pingBehaviour = true;
    ImageIcon dummyIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("images/dummy.gif"));
    SplashScreen splash;
    TestAgentFrame itsFrame;
    static /* synthetic */ Class class$jade$tools$testagent$TestAgent;

    public static void main(String[] args) {
        String host = "cross.hq.acklin.nl";
        String[] argsv = new String[]{"-host", host, "-container", "ruurd:jade.tools.testagent.TestAgent"};
        Boot.main((String[])argsv);
    }

    public ACLMessage getPlatformRequest() {
        ACLMessage msg = new ACLMessage(16);
        msg.setSender(this.getAID());
        msg.setEncoding("String");
        msg.setLanguage("fipa-sl0");
        msg.setOntology("FIPA-Agent-Management");
        msg.setProtocol("fipa-request");
        msg.setReplyWith("Req" + new Date().getTime());
        msg.setConversationId("Req" + new Date().getTime());
        return msg;
    }

    public void doRegisterAMS() {
        AMSAgentDescription amsAgentDescription = new AMSAgentDescription();
        amsAgentDescription.setName(this.getAID());
        amsAgentDescription.setOwnership(this.getHap());
        amsAgentDescription.setState("ACTIVE");
        Register register = new Register();
        register.setDescription((Object)amsAgentDescription);
        ACLMessage msg = this.createRequestMessage(this, this.getAMS(), (AgentAction)register);
        this.itsFrame.setItsMsg(msg);
    }

    public void doRegisterDF() {
        ServiceDescription serviceDescr = new ServiceDescription();
        serviceDescr.setName("testagent");
        serviceDescr.setOwnership(this.getHap());
        serviceDescr.setType("jade.testagent");
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(this.getAID());
        dFAgentDescription.addOntologies("FIPA-Agent-Management");
        dFAgentDescription.addLanguages("fipa-sl0");
        dFAgentDescription.addServices(serviceDescr);
        Register register = new Register();
        register.setDescription((Object)dFAgentDescription);
        ACLMessage msg = this.createRequestMessage(this, this.getDefaultDF(), (AgentAction)register);
        this.itsFrame.setItsMsg(msg);
    }

    public void doDeregisterDF() {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(this.getAID());
        Deregister deregister = new Deregister();
        deregister.setDescription((Object)dFAgentDescription);
        ACLMessage msg = this.createRequestMessage(this, this.getDefaultDF(), (AgentAction)deregister);
        this.itsFrame.setItsMsg(msg);
    }

    public void doDeRegisterAMS() {
        AMSAgentDescription amsAgentDescription = new AMSAgentDescription();
        amsAgentDescription.setName(this.getAID());
        Deregister deregister = new Deregister();
        deregister.setDescription((Object)amsAgentDescription);
        ACLMessage msg = this.createRequestMessage(this, this.getAMS(), (AgentAction)deregister);
        this.itsFrame.setItsMsg(msg);
    }

    public void doSearchAMS() {
        AMSAgentDescription amsAgentDescription = new AMSAgentDescription();
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxDepth(new Long(100L));
        searchConstraints.setMaxResults(new Long(100L));
        Search search = new Search();
        search.setConstraints(searchConstraints);
        search.setDescription((Object)amsAgentDescription);
        ACLMessage msg = this.createRequestMessage(this, this.getAMS(), (AgentAction)search);
        this.itsFrame.setItsMsg(msg);
    }

    public void doSearchDF() {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxDepth(new Long(100L));
        searchConstraints.setMaxResults(new Long(100L));
        Search search = new Search();
        search.setConstraints(searchConstraints);
        search.setDescription((Object)dFAgentDescription);
        ACLMessage msg = this.createRequestMessage(this, this.getDefaultDF(), (AgentAction)search);
        this.itsFrame.setItsMsg(msg);
    }

    public void doLausannePing() {
        ACLMessage msg = new ACLMessage(13);
        msg.setSender(this.getAID());
        AID aclPing = new AID("acl_ping", true);
        aclPing.setName("acl_ping@beta.lausanne.agentcities.net");
        aclPing.addAddresses("http://srv02.lausanne.agentcities.net:8080/acc");
        msg.addReceiver(aclPing);
        msg.setReplyWith("Req" + new Date().getTime());
        msg.setConversationId("Req" + new Date().getTime());
        msg.setContent("ping");
        this.itsFrame.setItsMsg(msg);
    }

    public void doLocalPing() {
        ACLMessage msg = new ACLMessage(13);
        msg.setSender(this.getAID());
        msg.addReceiver(this.getAID());
        msg.setReplyWith("Req" + new Date().getTime());
        msg.setConversationId("Req" + new Date().getTime());
        msg.setContent("ping");
        this.itsFrame.setItsMsg(msg);
    }

    public void doHelloWorld() {
        ACLMessage msg = new ACLMessage(7);
        msg.setSender(this.getAID());
        msg.addReceiver(this.getAID());
        msg.setContent("Hello World!");
        msg.setLanguage("Plain English");
        msg.setOntology("World Domination");
        msg.addUserDefinedParameter("key1", "value1");
        msg.addUserDefinedParameter("key2", "value2");
        msg.addUserDefinedParameter("key3", "value3");
        this.itsFrame.setItsMsg(msg);
    }

    public void doSystemOut() {
        System.out.println(this.itsFrame.getItsMsg());
    }

    public void doExit() {
        this.doDelete();
        System.exit(0);
    }

    public void doNewMessage() {
        ACLMessage msg = new ACLMessage(7);
        msg.setSender(this.getAID());
        this.itsFrame.setItsMsg(msg);
    }

    public void sendMessage() {
        ACLMessage msg = this.itsFrame.getItsMsg();
        this.itsFrame.addMessageNode("out", msg);
        this.send(msg);
        this.doNewMessage();
    }

    public void processIncomingMessage(ACLMessage msg) {
        this.itsFrame.addMessageNode("in", msg);
        if (this.pingBehaviour) {
            if (msg.getContent() == null) {
                return;
            }
            if (msg.getPerformative() == 13 && (msg.getContent().equalsIgnoreCase("ping") || msg.getContent().equalsIgnoreCase("(ping)"))) {
                ACLMessage alive = msg.createReply();
                alive.setPerformative(7);
                alive.setSender(this.getAID());
                alive.setContent("alive");
                this.send(alive);
                this.itsFrame.addMessageNode("out", alive);
            }
        }
    }

    public void doReply() {
        ACLMessage msg = this.itsFrame.aclTreePanel.getCurrentACL();
        if (msg == null) {
            return;
        }
        ACLMessage reply = msg.createReply();
        reply.setSender(this.getAID());
        this.itsFrame.aclPanel.setItsMsg(reply);
    }

    protected void setup() {
        super.setup();
        this.splash = new SplashScreen();
        this.splash.show();
        this.splash.setProgress(25);
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, "starting up: " + this.getAID().toString());
        }
        try {
            this.getContentManager().registerLanguage((Codec)new SLCodec(), "fipa-sl0");
            this.getContentManager().registerOntology(FIPAManagementOntology.getInstance(), "FIPA-Agent-Management");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.splash.setProgress(50);
        this.itsFrame = new TestAgentFrame(this);
        this.splash.setProgress(75);
        this.addBehaviour((Behaviour)new ReceiveCyclicBehaviour(this));
        this.splash.setProgress(100);
        this.splash.hide();
    }

    ACLMessage createRequestMessage(Agent sender, AID receiver, AgentAction what) {
        ACLMessage request = new ACLMessage(16);
        request.setSender(sender.getAID());
        request.addReceiver(receiver);
        request.setProtocol("fipa-request");
        request.setLanguage("fipa-sl0");
        request.setEncoding("String");
        request.setOntology("FIPA-Agent-Management");
        request.setReplyWith("rw" + sender.getName() + new Date().getTime());
        request.setConversationId("conv" + sender.getName() + new Date().getTime());
        Action act = new Action();
        act.setActor(receiver);
        act.setAction((Concept)what);
        try {
            this.getContentManager().fillContent(request, (ContentElement)act);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return request;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SplashScreen
    extends JWindow {
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JPanel jPanel1 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JLabel jLabel1 = new JLabel();
        JProgressBar theProgressBar = new JProgressBar();

        public SplashScreen() {
            try {
                this.jbInit();
                this.setSize(400, 50);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation(screenSize.width / 2 - this.getSize().width / 2, screenSize.height / 2 - this.getSize().height / 2);
                this.setVisible(true);
                this.requestFocus();
                Toolkit.getDefaultToolkit().sync();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setProgress(int p) {
            this.theProgressBar.setValue(p);
        }

        void jbInit() {
            this.getContentPane().setLayout(this.gridBagLayout1);
            this.getContentPane().setBackground(Color.white);
            this.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ SplashScreen this$1;
                {
                    this.this$1 = this$1;
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.black));
            this.jPanel1.setLayout(this.gridBagLayout2);
            this.jLabel1.setBackground(Color.white);
            this.jLabel1.setForeground(Color.blue);
            this.jLabel1.setOpaque(true);
            this.jLabel1.setHorizontalAlignment(0);
            this.jLabel1.setText("loading, please wait...");
            this.jLabel1.setIcon(TestAgent.this.dummyIcon);
            this.theProgressBar.setBackground(Color.white);
            this.theProgressBar.setForeground(Color.blue);
            this.theProgressBar.setValue(5);
            this.theProgressBar.setStringPainted(true);
            this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.theProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 14, 2, new Insets(2, 5, 2, 5), 0, 0));
        }
    }
}

