/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.Utils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class ClassRecord {
    private String vmName;
    private String name;
    private Class cls;
    private Constructor[] ctors;
    private Method[] methods;
    private Field[] fields;
    private Class componentType;
    private int depth;
    private static final int NOT = 0;
    private static final int ASSIGNABLE = 1;
    private static final int EXACTLY = 2;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$com$wolfram$jlink$Expr;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    ClassRecord(String name, ClassLoader loader, String vmName) throws ClassNotFoundException, SecurityException {
        if (loader == null) {
            loader = JLinkClassLoader.getInstance();
        }
        this.cls = Class.forName(name, false, loader);
        this.vmName = vmName;
        this.name = this.cls.getName();
        this.ctors = this.cls.getConstructors();
        this.methods = this.cls.getMethods();
        this.fields = this.cls.getFields();
        int m = this.cls.getModifiers();
        if (!Modifier.isPublic(m)) {
            try {
                AccessibleObject.setAccessible(this.methods, true);
                AccessibleObject.setAccessible(this.fields, true);
            }
            catch (SecurityException e) {
                System.err.println("Warning: the non-public class " + name + " was loaded by J/Link, and the attempt " + "to make its public methods accessible from Mathematica failed due to a Java " + "security restriction. Objects of this class may generate an IllegalAccessException  " + "when they are used from Mathematica. See the documentation for the class " + "java.lang.reflect.ReflectPermission.");
            }
        }
        this.componentType = Utils.getArrayComponentType(this.cls);
        if (this.componentType != null) {
            this.depth = 0;
            while (name.charAt(this.depth) == '[') {
                ++this.depth;
            }
        }
    }

    Class getCls() {
        return this.cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putInfo(KernelLink kl, String symbolNameOfObjSupplyingClassLoader) throws MathLinkException {
        LoopbackLink loop = MathLinkFactory.createLoopbackLink();
        Error err = null;
        Class complexClass = kl.getComplexClass();
        try {
            int j;
            loop.putFunction("List", 6);
            loop.put(this.name);
            loop.putFunction("JLink`Package`loadClassFromJava", 3);
            loop.put(this.vmName);
            Class sup = this.cls.getSuperclass();
            loop.put(sup == null ? null : sup.getName());
            loop.putSymbol(symbolNameOfObjSupplyingClassLoader);
            loop.put(this.cls.isInterface());
            if (this.componentType != null) {
                if (this.depth == 1) {
                    loop.putFunction("List", 2);
                    loop.putFunction("List", 3);
                    loop.put(1);
                    loop.put("");
                    loop.put(ClassRecord.classToMathLinkConstant(Integer.TYPE, complexClass, true));
                } else {
                    loop.putFunction("List", 1);
                }
                loop.putFunction("List", 3);
                loop.put(0);
                loop.put("");
                loop.put(ClassRecord.classToMathLinkConstant(array$I == null ? (array$I = ClassRecord.class$("[I")) : array$I, complexClass, true));
            } else {
                loop.putFunction("List", this.ctors.length);
                for (int i = 0; i < this.ctors.length; ++i) {
                    Class[] params = this.ctors[i].getParameterTypes();
                    boolean hasAmbiguity = ClassRecord.hasRealIntAmbiguity(i, params, this.ctors);
                    loop.putFunction("List", params.length + 2);
                    loop.put(i);
                    loop.put(this.ctors[i].toString());
                    for (int j2 = 0; j2 < params.length; ++j2) {
                        loop.put(ClassRecord.classToMathLinkConstant(params[j2], complexClass, hasAmbiguity));
                    }
                }
            }
            Method[] declMethods = this.cls.getDeclaredMethods();
            String[] names = new String[declMethods.length];
            for (int i = 0; i < declMethods.length; ++i) {
                names[i] = declMethods[i].getName();
            }
            int len = this.methods.length;
            loop.putFunction("DeleteCases", 2);
            loop.putFunction("List", len);
            for (int i = 0; i < len; ++i) {
                boolean sendThisMethod;
                boolean isStatic;
                Method meth;
                block29: {
                    String name;
                    meth = this.methods[i];
                    isStatic = Modifier.isStatic(meth.getModifiers());
                    sendThisMethod = false;
                    if (meth.getDeclaringClass() == this.cls) {
                        sendThisMethod = true;
                    } else if (isStatic) {
                        sendThisMethod = true;
                        name = meth.getName();
                        Class<?>[] params = meth.getParameterTypes();
                        for (j = 0; j < declMethods.length; ++j) {
                            Class<?>[] otherParams;
                            if (!name.equals(names[j]) || (otherParams = declMethods[j].getParameterTypes()).length != params.length) continue;
                            sendThisMethod = false;
                            for (int k = 0; k < params.length; ++k) {
                                if (params[k] == otherParams[k]) continue;
                                sendThisMethod = true;
                                break block29;
                            }
                        }
                    } else {
                        name = meth.getName();
                        for (int j3 = 0; j3 < declMethods.length; ++j3) {
                            if (!name.equals(names[j3])) continue;
                            sendThisMethod = true;
                            break;
                        }
                    }
                }
                if (sendThisMethod) {
                    Class[] params = meth.getParameterTypes();
                    boolean hasAmbiguity = ClassRecord.hasRealIntAmbiguity(i, params, this.methods);
                    loop.putFunction("List", params.length + 4);
                    loop.put(i);
                    loop.put(meth.toString());
                    loop.put(isStatic);
                    loop.put(meth.getName());
                    for (j = 0; j < params.length; ++j) {
                        loop.put(ClassRecord.classToMathLinkConstant(params[j], complexClass, hasAmbiguity));
                    }
                    continue;
                }
                loop.putSymbol("Null");
            }
            loop.putSymbol("Null");
            Field[] declFields = this.cls.getDeclaredFields();
            names = new String[declFields.length];
            for (int j4 = 0; j4 < declFields.length; ++j4) {
                names[j4] = declFields[j4].getName();
            }
            len = this.fields.length;
            loop.putFunction("DeleteCases", 2);
            loop.putFunction("List", len);
            for (int i = 0; i < len; ++i) {
                boolean sendThisField = true;
                Field fld = this.fields[i];
                boolean isStatic = Modifier.isStatic(fld.getModifiers());
                if (isStatic && fld.getDeclaringClass() != this.cls) {
                    String name = fld.getName();
                    for (j = 0; j < declFields.length; ++j) {
                        if (!name.equals(names[j])) continue;
                        sendThisField = false;
                        break;
                    }
                }
                if (sendThisField) {
                    loop.putFunction("List", 5);
                    loop.put(i);
                    loop.put(isStatic);
                    loop.put(fld.getType().toString());
                    loop.put(fld.getName());
                    loop.put(ClassRecord.classToMathLinkConstant(fld.getType(), complexClass, false));
                    continue;
                }
                loop.putSymbol("Null");
            }
            loop.putSymbol("Null");
        }
        catch (Error e) {
            err = e;
        }
        finally {
            if (err != null) {
                kl.message("Java::excptn", err.toString());
                kl.putSymbol("$Failed");
            } else {
                kl.transferExpression(loop);
            }
            loop.close();
        }
    }

    private static int classToMathLinkConstant(Class cls, Class complexClass, boolean hasRealIntAmbiguity) {
        int res = 0;
        if (cls.isPrimitive()) {
            if (cls == Integer.TYPE) {
                res = -5;
            } else if (cls == Double.TYPE) {
                res = hasRealIntAmbiguity ? -8 : -16;
            } else if (cls == Boolean.TYPE) {
                res = -1;
            } else if (cls == Byte.TYPE) {
                res = -2;
            } else if (cls == Character.TYPE) {
                res = -3;
            } else if (cls == Short.TYPE) {
                res = -4;
            } else if (cls == Long.TYPE) {
                res = -6;
            } else if (cls == Float.TYPE) {
                res = hasRealIntAmbiguity ? -7 : -15;
            }
        } else {
            res = cls == (class$java$lang$String == null ? (class$java$lang$String = ClassRecord.class$("java.lang.String")) : class$java$lang$String) ? -9 : (cls == complexClass ? -13 : (cls.isArray() ? -17 + ClassRecord.classToMathLinkConstant(cls.getComponentType(), complexClass, hasRealIntAmbiguity) : (cls == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = ClassRecord.class$("java.math.BigInteger")) : class$java$math$BigInteger) ? -10 : (cls == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ClassRecord.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) ? -11 : (cls == (class$com$wolfram$jlink$Expr == null ? (class$com$wolfram$jlink$Expr = ClassRecord.class$("com.wolfram.jlink.Expr")) : class$com$wolfram$jlink$Expr) ? -12 : -14)))));
        }
        return res;
    }

    private static boolean hasRealIntAmbiguity(int thisIndex, Class[] params, Member[] members) {
        boolean isMethod;
        String thisName = members[thisIndex].getName();
        boolean hasRealParam = false;
        for (int j = 0; j < params.length; ++j) {
            Class c = params[j];
            if (c.isArray()) {
                c = Utils.getArrayComponentType(c);
            }
            if (c != Float.TYPE && c != Double.TYPE) continue;
            hasRealParam = true;
            break;
        }
        boolean bl = isMethod = members.length > 0 && members[0] instanceof Method;
        if (hasRealParam) {
            for (int j = 0; j < members.length; ++j) {
                Class<?>[] otherParams;
                Member otherMember = members[j];
                if (j == thisIndex || !otherMember.getName().equals(thisName)) continue;
                Class<?>[] classArray = otherParams = isMethod ? ((Method)otherMember).getParameterTypes() : ((Constructor)otherMember).getParameterTypes();
                if (otherParams.length != params.length) continue;
                for (int k = 0; k < params.length; ++k) {
                    Class p = params[k];
                    Class op = otherParams[k];
                    if (p.isArray() && op.isArray()) {
                        p = Utils.getArrayComponentType(p);
                        op = Utils.getArrayComponentType(op);
                    }
                    if (p != Float.TYPE && p != Double.TYPE || op != Integer.TYPE && op != Long.TYPE && op != Short.TYPE && op != Character.TYPE && op != Byte.TYPE) continue;
                    return true;
                }
            }
        }
        return false;
    }

    synchronized Object callField(boolean isSet, Object instance, int fieldIndex, Object val) throws IllegalAccessException, NoSuchMethodException {
        Field f = this.fields[fieldIndex];
        if (isSet) {
            f.set(instance, val);
            return null;
        }
        return f.get(instance);
    }

    Object callBestCtor(int[] indices, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object res = null;
        if (this.componentType != null) {
            int[] dims = indices[0] == 0 ? (int[])args[0] : new int[]{(Integer)args[0]};
            res = Array.newInstance(this.componentType, dims);
        } else {
            Constructor ctor = (Constructor)this.bestMember(indices, args, false);
            res = ctor.newInstance(args);
        }
        return res;
    }

    Object callBestMethod(int[] indices, Object instance, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method meth = (Method)this.bestMember(indices, args, true);
        return meth.invoke(instance, args);
    }

    private Object bestMember(int[] indices, Object[] args, boolean isMethod) {
        int i;
        int len = indices.length;
        if (len == 1) {
            return isMethod ? this.methods[indices[0]] : this.ctors[indices[0]];
        }
        Class[] argClasses = new Class[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            argClasses[i2] = args[i2].getClass();
        }
        boolean[] objsAssignable = new boolean[len];
        boolean[] primitivesMatch = new boolean[len];
        boolean atLeastOneMethodMatchesObjects = false;
        for (i = 0; i < len; ++i) {
            Class[] paramClasses = isMethod ? this.methods[indices[i]].getParameterTypes() : this.ctors[indices[i]].getParameterTypes();
            int objsMatch = ClassRecord.objectClassesMatch(argClasses, paramClasses);
            boolean primsMatch = ClassRecord.primitiveClassesMatch(argClasses, paramClasses);
            if (objsMatch == 2 && primsMatch) {
                return isMethod ? this.methods[indices[i]] : this.ctors[indices[i]];
            }
            if (objsMatch == 2 || objsMatch == 1) {
                objsAssignable[i] = true;
                atLeastOneMethodMatchesObjects = true;
            }
            if (!primsMatch) continue;
            primitivesMatch[i] = true;
        }
        if (!atLeastOneMethodMatchesObjects) {
            return isMethod ? this.methods[indices[0]] : this.ctors[indices[0]];
        }
        for (i = 0; i < len; ++i) {
            if (!objsAssignable[i] || !primitivesMatch[i]) continue;
            return isMethod ? this.methods[indices[i]] : this.ctors[indices[i]];
        }
        Object[] newArgs = new Object[args.length];
        for (int i3 = 0; i3 < len; ++i3) {
            Class[] paramClasses;
            if (!objsAssignable[i3]) continue;
            System.arraycopy(args, 0, newArgs, 0, args.length);
            Class[] classArray = paramClasses = isMethod ? this.methods[indices[i3]].getParameterTypes() : this.ctors[indices[i3]].getParameterTypes();
            if (!ClassRecord.massagePrimitives(argClasses, paramClasses, newArgs)) continue;
            System.arraycopy(newArgs, 0, args, 0, args.length);
            return isMethod ? this.methods[indices[i3]] : this.ctors[indices[i3]];
        }
        return isMethod ? this.methods[indices[0]] : this.ctors[indices[0]];
    }

    private static int objectClassesMatch(Class[] argClasses, Class[] paramClasses) {
        int len = argClasses.length;
        int match = 2;
        for (int i = 0; i < len; ++i) {
            Class argCls = argClasses[i];
            Class paramCls = paramClasses[i];
            if (paramCls.isPrimitive() || paramCls == argCls) continue;
            if (paramCls.isAssignableFrom(argCls)) {
                match = 1;
                continue;
            }
            return 0;
        }
        return match;
    }

    private static boolean primitiveClassesMatch(Class[] argClasses, Class[] paramClasses) {
        int len = argClasses.length;
        for (int i = 0; i < len; ++i) {
            boolean argsMatch = true;
            Class argCls = argClasses[i];
            Class paramCls = paramClasses[i];
            if (paramCls.isPrimitive()) {
                if (paramCls == Integer.TYPE) {
                    argsMatch = argCls == (class$java$lang$Integer == null ? ClassRecord.class$("java.lang.Integer") : class$java$lang$Integer);
                } else if (paramCls == Double.TYPE) {
                    argsMatch = argCls == (class$java$lang$Double == null ? ClassRecord.class$("java.lang.Double") : class$java$lang$Double);
                } else if (paramCls == Boolean.TYPE) {
                    argsMatch = argCls == (class$java$lang$Boolean == null ? ClassRecord.class$("java.lang.Boolean") : class$java$lang$Boolean);
                } else if (paramCls == Byte.TYPE) {
                    argsMatch = argCls == (class$java$lang$Byte == null ? ClassRecord.class$("java.lang.Byte") : class$java$lang$Byte);
                } else if (paramCls == Long.TYPE) {
                    argsMatch = argCls == (class$java$lang$Long == null ? ClassRecord.class$("java.lang.Long") : class$java$lang$Long);
                } else if (paramCls == Float.TYPE) {
                    argsMatch = argCls == (class$java$lang$Float == null ? ClassRecord.class$("java.lang.Float") : class$java$lang$Float);
                } else if (paramCls == Short.TYPE) {
                    argsMatch = argCls == (class$java$lang$Short == null ? ClassRecord.class$("java.lang.Short") : class$java$lang$Short);
                } else if (paramCls == Character.TYPE) {
                    boolean bl = argsMatch = argCls == (class$java$lang$Character == null ? ClassRecord.class$("java.lang.Character") : class$java$lang$Character);
                }
            }
            if (argsMatch) continue;
            return false;
        }
        return true;
    }

    private static boolean massagePrimitives(Class[] argClasses, Class[] paramClasses, Object[] newArgs) {
        for (int i = 0; i < newArgs.length; ++i) {
            Class paramCls = paramClasses[i];
            Class argCls = argClasses[i];
            if (!paramCls.isPrimitive()) continue;
            if (paramCls == Integer.TYPE) {
                if (argCls != (class$java$lang$Long == null ? ClassRecord.class$("java.lang.Long") : class$java$lang$Long)) continue;
                long val = ((Number)newArgs[i]).longValue();
                if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                    newArgs[i] = new Integer((int)val);
                    continue;
                }
                return false;
            }
            if (paramCls == Short.TYPE) {
                if (argCls != (class$java$lang$Long == null ? ClassRecord.class$("java.lang.Long") : class$java$lang$Long) && argCls != (class$java$lang$Integer == null ? ClassRecord.class$("java.lang.Integer") : class$java$lang$Integer)) continue;
                long val = ((Number)newArgs[i]).longValue();
                if (val <= 32767L && val >= -32768L) {
                    newArgs[i] = new Short((short)val);
                    continue;
                }
                return false;
            }
            if (paramCls == Character.TYPE) {
                if (argCls != (class$java$lang$Long == null ? ClassRecord.class$("java.lang.Long") : class$java$lang$Long) && argCls != (class$java$lang$Integer == null ? ClassRecord.class$("java.lang.Integer") : class$java$lang$Integer) && argCls != (class$java$lang$Short == null ? ClassRecord.class$("java.lang.Short") : class$java$lang$Short)) continue;
                long val = ((Number)newArgs[i]).longValue();
                if (val <= 65535L && val >= 0L) {
                    newArgs[i] = new Character((char)val);
                    continue;
                }
                return false;
            }
            if (paramCls == Byte.TYPE) {
                long val;
                if (argCls != (class$java$lang$Long == null ? ClassRecord.class$("java.lang.Long") : class$java$lang$Long) && argCls != (class$java$lang$Integer == null ? ClassRecord.class$("java.lang.Integer") : class$java$lang$Integer) && argCls != (class$java$lang$Short == null ? ClassRecord.class$("java.lang.Short") : class$java$lang$Short) && argCls != (class$java$lang$Character == null ? ClassRecord.class$("java.lang.Character") : class$java$lang$Character)) continue;
                long l = val = argCls == (class$java$lang$Character == null ? ClassRecord.class$("java.lang.Character") : class$java$lang$Character) ? (long)((Character)newArgs[i]).charValue() : ((Number)newArgs[i]).longValue();
                if (val <= 127L && val >= -128L) {
                    newArgs[i] = new Byte((byte)val);
                    continue;
                }
                return false;
            }
            if (paramCls != Float.TYPE || argCls != (class$java$lang$Double == null ? ClassRecord.class$("java.lang.Double") : class$java$lang$Double)) continue;
            double d = Math.abs((Double)newArgs[i]);
            if (d <= 3.4028234663852886E38 && d >= (double)1.4E-45f) {
                newArgs[i] = new Float((float)d);
                continue;
            }
            return false;
        }
        return true;
    }

    void callOnLoadClass(KernelLink ml) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < this.methods.length; ++i) {
            Class<?>[] params;
            String name = this.methods[i].getName();
            if (!name.equals("onLoadClass") || (params = this.methods[i].getParameterTypes()).length != 1 || !params[0].isInstance(ml)) continue;
            Object[] args = new Object[]{ml};
            this.methods[i].invoke(null, args);
        }
    }

    private void fillObjectArrayFromCtor(Object array, Constructor compCtor, int[] dims, int depth) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (depth == dims.length - 1) {
            for (int i = 0; i < dims[depth]; ++i) {
                Array.set(array, i, compCtor.newInstance(null));
            }
        } else {
            for (int i = 0; i < dims[depth]; ++i) {
                this.fillObjectArrayFromCtor(((Object[])array)[i], compCtor, dims, depth + 1);
            }
        }
    }

    void callOnUnloadClass(KernelLink ml) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < this.methods.length; ++i) {
            Class<?>[] params;
            String name = this.methods[i].getName();
            if (!name.equals("onUnloadClass") || (params = this.methods[i].getParameterTypes()).length != 1 || !params[0].isInstance(ml)) continue;
            Object[] args = new Object[]{ml};
            this.methods[i].invoke(null, args);
        }
    }

    int reflect(MathLink ml, int type, boolean includeInherited, boolean sendData) throws MathLinkException {
        int num = 0;
        switch (type) {
            case 1: {
                num = this.ctors.length;
                if (!sendData) break;
                for (int i = 0; i < num; ++i) {
                    ml.put(this.ctors[i].toString());
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.methods.length; ++i) {
                    if (!includeInherited && this.methods[i].getDeclaringClass() != this.cls) continue;
                    ++num;
                    if (!sendData) continue;
                    ml.put(this.methods[i].toString());
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.fields.length; ++i) {
                    if (!includeInherited && this.fields[i].getDeclaringClass() != this.cls) continue;
                    ++num;
                    if (!sendData) continue;
                    boolean isStatic = Modifier.isStatic(this.fields[i].getModifiers());
                    boolean isFinal = Modifier.isFinal(this.fields[i].getModifiers());
                    String typeStr = this.fields[i].getType().toString();
                    if (typeStr.startsWith("class ")) {
                        typeStr = typeStr.substring(6);
                    }
                    ml.put((isStatic ? "static " : "") + (isFinal ? "final " : "") + typeStr + " " + this.fields[i].getName());
                }
                break;
            }
        }
        return num;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

