/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkSecurityManager;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.StdLink;

public class Reader
extends Thread {
    private KernelLink ml;
    private boolean quitWhenLinkEnds = true;
    private boolean requestedStop = false;
    private boolean isMainLink;
    private static Reader reader;
    private static int sleepInterval;

    public static Thread startReader(KernelLink ml, boolean quitWhenLinkEnds, boolean alwaysPoll) {
        reader = new Reader(ml, quitWhenLinkEnds, true);
        reader.start();
        StdLink.setLink(ml);
        StdLink.setHasReader(true);
        return reader;
    }

    public static Thread stopReader() {
        Reader.reader.requestedStop = true;
        StdLink.setHasReader(false);
        return reader;
    }

    public Reader(KernelLink ml, boolean quitWhenLinkEnds, boolean isMainLink) {
        super("J/Link reader" + (isMainLink ? "" : "2"));
        this.setContextClassLoader(ml.getClassLoader());
        this.ml = ml;
        this.quitWhenLinkEnds = quitWhenLinkEnds;
        this.isMainLink = isMainLink;
        ml.addMessageHandler(null, this, "terminateMsgHandler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block31: {
            loopsAgo = 0L;
            mustPoll = false;
            while (true) lbl-1000:
            // 4 sources

            {
                block32: {
                    if (this.requestedStop) break block31;
                    if (!this.isMainLink || !mustPoll) break block32;
                    isReady = false;
                    try {
                        isReady = this.ml.ready();
                        if (!isReady) {
                            Reader.sleep((long)Reader.sleepInterval + Math.min(loopsAgo++, 20L));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    e = this.ml;
                    synchronized (e) {
                        try {
                            if (this.ml.error() != 0) {
                                throw new MathLinkException(this.ml.error(), this.ml.errorMessage());
                            }
                            if (isReady) {
                                loopsAgo = 0L;
                                pkt = this.ml.nextPacket();
                                this.ml.handlePacket(pkt);
                                this.ml.newPacket();
                                mustPoll = StdLink.mustPoll();
                            }
                            ** GOTO lbl-1000
                        }
                        catch (MathLinkException e) {
                            if (e.getErrCode() == 11 || !this.ml.clearError()) {
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 19, 11, 27, 13] lbl32 : MonitorExitStatement: MONITOREXIT : e
                                if (this.quitWhenLinkEnds) {
                                    this.ml.close();
                                    this.ml = null;
                                    if (StdLink.getUILink() != null) {
                                        StdLink.getUILink().close();
                                        StdLink.setUILink(null);
                                    }
                                    StdLink.setLink(null);
                                    JLinkSecurityManager.setAllowExit(true);
                                    System.exit(0);
                                }
                                return;
                            }
                            this.ml.newPacket();
                            continue;
                        }
                    }
                }
                var4_4 = this.ml;
                synchronized (var4_4) {
                    try {
                        pkt = this.ml.nextPacket();
                        this.ml.handlePacket(pkt);
                        this.ml.newPacket();
                        mustPoll = StdLink.mustPoll();
                        ** GOTO lbl72
                    }
                    catch (MathLinkException e) {
                        if (e.getErrCode() == 11 || !this.ml.clearError()) {
                            // MONITOREXIT @DISABLED, blocks:[19, 6, 24, 10, 15] lbl61 : MonitorExitStatement: MONITOREXIT : var4_4
                            if (this.quitWhenLinkEnds) {
                                this.ml.close();
                                this.ml = null;
                                if (StdLink.getUILink() != null) {
                                    StdLink.getUILink().close();
                                    StdLink.setUILink(null);
                                }
                                StdLink.setLink(null);
                                JLinkSecurityManager.setAllowExit(true);
                                System.exit(0);
                            }
                            return;
                        }
                        this.ml.newPacket();
lbl72:
                        // 2 sources

                        // MONITOREXIT @DISABLED, blocks:[19, 6, 8, 9, 10, 15] lbl75 : MonitorExitStatement: MONITOREXIT : var4_4
                        continue;
                    }
                }
                break;
            }
            finally {
                if (this.quitWhenLinkEnds) {
                    this.ml.close();
                    this.ml = null;
                    if (StdLink.getUILink() != null) {
                        StdLink.getUILink().close();
                        StdLink.setUILink(null);
                    }
                    StdLink.setLink(null);
                    JLinkSecurityManager.setAllowExit(true);
                    System.exit(0);
                }
            }
        }
    }

    public void terminateMsgHandler(int msg, int ignore) {
        if (msg == 1) {
            this.stop();
            this.ml.setYieldFunction(null, this, "terminateYielder");
            this.requestedStop = true;
        }
    }

    boolean terminateYielder() {
        return true;
    }

    static {
        sleepInterval = 2;
    }
}

