/*****************************************************************************\
*   RestrictionListPanel.java                                                 *
*                                                                             *
*   Copyright 2005, Paul M Evans                                              *
*                                                                             *
*   This file is part of SiteFind.                                            *
*                                                                             *
*   SiteFind is free software; you can redistribute it and/or modify          *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   SiteFind is distributed in the hope that it will be useful,               *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Foobar; if not, write to the Free Software                     *
*   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA  *
\*****************************************************************************/

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

// RestrictionListPanel
public class RestrictionListPanel extends NextPanel {
	JList listBox;
	JButton addButton, removeButton, clearButton, defaultButton;
	DefaultListModel listModel;
	Map enzymeList;

	String wildTypeDNASeq, mutantAminoSeq;

	static String[] nameList = {
		/*  1- 5 */ "AbrI",     "AccI",      "AgeI",      "AluI",    "ApaLI",
		/*  6-10 */ "AquI",     "AvaI",      "BamHI",     "BamHII",  "BanI",
		/* 11-15 */ "BanIII",   "BbvI(1)",   "BbvI(2)",   "BepI",    "BglI",
		/* 16-20 */ "BglII",    "BseCI",     "BslI",      "BsoBI",   "Bsp6I",
		/* 21-25 */ "BspRI",    "BstVI",     "BsuBI",     "BsuFI",   "BsuRI",
		/* 26-30 */ "CeqI",     "Cfr9I",     "Cfr10I",    "CfrBI",   "ClaI",
		/* 31-35 */ "CviAII",   "CviBI",     "CviJI",     "CviRI",   "DdeI",
		/* 36-40 */ "DpnI",     "DpnII",     "DsaV",      "EcaI",    "Eco47I",
		/* 41-45 */ "Eco47II",  "Eco57I(1)", "Eco57I(2)", "EcoRI",   "EcoRII",
		/* 46-50 */ "EcoRV",    "FnuDI",     "FokI(1)",   "FokI(2)", "HaeII",
		/* 51-55 */ "HaeIII",   "HgaI(1)",   "HgaI(2)",   "HgiBI",   "HgiCI",
		/* 56-60 */ "HgiCII",   "HgiDI",     "HgiDII",    "HgiEI",   "HgiGI",
		/* 61-65 */ "HhaI",     "HhaII",     "HincII",    "HindII",  "HindIII",
		/* 66-70 */ "HindV",    "HinfI",     "HpaI",      "HpaII",   "HphI(1)",
		/* 71-75 */ "HphI(2)",  "KpnI",      "LlaDCHI",   "MamI",    "MboI",
		/* 76-80 */ "MboII(1)", "MboII(2)",  "MjaI",      "MjaII",   "MjaIII",
		/* 81-85 */ "MjaIV",    "MjaV",      "MjaVI",     "MspI",    "MthTI",
		/* 86-90 */ "MthZI",    "MunI",      "MvaI",      "MwoI",    "NaeI",
		/* 91-95 */ "NcoI",     "NdeI",      "NgoBI",     "NgoBV",   "NgoFVII",
		/* 96-100*/ "NgoMIV",   "NgoPII",    "NheI",      "NlaIII",  "NlaIV",
		/*101-105*/ "NotI",     "NsiI",      "NspV",      "PaeR7I",  "PspPI",
		/*106-110*/ "PstI",     "PvuI",      "PvuII",     "RsrI",    "SacI",
		/*111-115*/ "Sau3AI",   "Sau96I",    "ScaI",      "ScrFI",   "SfiI",
		/*116-120*/ "SalI",     "SinI",      "SmaI",      "SnaBI",   "SpeI",
		/*121-125*/ "SsoII",    "StsI(1)",   "StsI(2)",   "TaqI",    "TthHB8I",
		/*126-130*/ "VspI",     "XamI",      "XbaI",      "XcyI",    "XhoI",
		/*131*/     "XorII"
	};
	static String[] siteList = {
		/*  1- 5 */ "CTCGAG",      "GTMKAC",      "ACCGGT",      "AGCT",        "GTGCAC",
		/*  6-10 */ "CYCGRG",      "CYCGRG",      "GGATCC",      "GGATCC",      "GGYRCC",
		/* 11-15 */ "ATCGAT",      "GCAGC",       "GCTGC",       "CGCG",        "GCCNNNNNGGC",
		/* 16-20 */ "AGATCT",      "ATCGAT",      "CCNNNNNNNGG", "CYCGRG",      "GCNGC",
		/* 21-25 */ "GGCC",        "CTCGAG",      "CTGCAG",      "CCGG",        "GGCC",
		/* 26-30 */ "GATATC",      "CCCGGG",      "RCCGGY",      "CCWWGG",      "ATCGAT",
		/* 31-35 */ "CATG",        "GANTC",       "RGCY",        "TGCA",        "CTNAG",
		/* 36-40 */ "GATC",        "GATC",        "CCNGG",       "GGTNACC",     "GGWCC",
		/* 41-45 */ "GGNCC",       "CTGAAG",      "CTTCAG",      "GAATTC",      "CCWGG",
		/* 46-50 */ "GATATC",      "GGCC",        "GGATG",       "CATCC",       "RGCGCY",
		/* 51-55 */ "GGCC",        "GACGC",       "GCGTC",       "GGWCC",       "GGYRCC",
		/* 56-60 */ "GGWCC",       "GRCGYC",      "GTCGAC",      "GGWCC",       "GRCGYC",
		/* 61-65 */ "GCGC",        "GANTC",       "GTYRAC",      "GTYRAC",      "AAGCTT",
		/* 66-70 */ "GRCGYC",      "GANTC",       "GTTAAC",      "CCGG",        "GGTGA",
		/* 71-75 */ "TCACC",       "GGTACC",      "GATC",        "GATNNNNATC",  "GATC",
		/* 76-80 */ "GAAGA",       "TCTTC",       "CTAG",        "CCNG",        "GATC",
		/* 81-85 */ "GTNNAC",      "GTAC",        "CCGG",        "CCGG",        "GGCC",
		/* 86-90 */ "CTAG",        "CAATTG",      "CCWGG",       "GCNNNNNNNGC", "GCCGGC",
		/* 91-95 */ "CCATGG",      "CATATG",      "RGCGCY",      "GGNNCC",      "GCSGC",
		/* 96-100*/ "GCCGGC",      "GGCC",        "GCTAGC",      "CATG",        "GGNNCC",
		/*101-105*/ "GCGGCCGC",    "ATGCAT",      "TTCGAA",      "CTCGAG",      "GGNCC",
		/*106-110*/ "CTGCAG",      "CGATCG",      "CAGCTG",      "GAATTC",      "GAGCTC",
		/*111-115*/ "GATC",        "GGNCC",       "AGTACT",      "CCNGG",       "GGCCNNNNNGGCC",
		/*116-120*/ "GTCGAC",      "GGWCC",       "CCCGGG",      "TACGTA",      "ACTAGT",
		/*121-125*/ "CCNGG",       "GGATG",       "CATCC",       "TCGA",        "TCGA",
		/*126-130*/ "ATTAAT",      "GTCGAC",      "TCTAGA",      "CCCGGG",      "CTCGAG",
		/*131*/     "CGATCG"



		/*"AatI", "AgeI", "ApaI", "AseI", "Asp718", "AvrII",
		"BamHI", "BglII","BspDI", "BspEI", "BspHI", "BsrBI",
		"BsrGI", "BssHII", "BstBI", "BstEII", "BstXI", "BstZ17",
		"ClaI", "DpnI", "DraI", "EagI", "EcoRI", "EcoRV",
		"FseI", "FspI", "HindIII", "HpaI", "KasI", "KpnI",
		"MfeI", "MluI", "MscI", "NaeI", "NarI", "NcoI",
		"NdeI", "NheI", "NotI", "NruI", "NsiI", "PacI",
		"PmeI", "PmlI", "PstI", "PvuI", "PvuII", "SacI",
		"SacII", "SalI", "ScaI", "SfoI", "SmaI", "SnaBI",
		"SpeI", "SphI", "SspI", "StuI", "SwaI", "XbaI",
		"XhoI", "XmaI"*/
		/*"GACGTC", "ACCGGT", "GGGCCC", "ATTAAT", "GGTACC", "CCTAGG",
		"GGATCC", "AGATCT", "ATCGAT", "TCCGGA", "TCATGA", "CCGCTC",
		"TGTACA", "GCGCGC", "TTCGAA", "GGTNACC", "CCANNNNNNTGG", "GTATAC",
		"ATCGAT", "GATC", "TTTAAA", "CGGCCG", "GAATTC", "GATATC",
		"GGCCGGCC", "TGCGCA", "AAGCTT", "GTTAAC", "GGCGCC", "GGTACC",
		"CAATTG", "ACGCGT", "TGGCCA", "GCCGGC", "GGCGCC", "CCATGG",
		"CATATG", "GCTAGC", "GCGGCCGC", "TCGCGA", "ATGCAT", "TTAATTAA",
		"GTTTAAAC", "CACGTG", "CTGCAG", "CGATCG", "CAGCTG", "GAGCTC",
		"CCGCGG", "GTCGAC", "AGTACT", "GGCGCC", "CCCGGG", "TACGTA",
		"ACTAGT", "GCATGC", "AATATT", "AGGCCT", "ATTTAAAT", "TCTAGA",
		"CTCGAG", "CCCGGG"*/
	};

	public RestrictionListPanel(NextPanelListener n, Map e) {
		super(n);

		enzymeList = e;
		listModel = new DefaultListModel();
		listBox = new JList(listModel);
		addButton = new JButton("Add");
		removeButton = new JButton("Remove");
		clearButton = new JButton("Clear");
		defaultButton = new JButton("Default");

		JPanel buttonPanel = new JPanel(new GridLayout(4, 1, 5, 5));
		buttonPanel.add(addButton);
		buttonPanel.add(removeButton);
		buttonPanel.add(clearButton);
		buttonPanel.add(defaultButton);
		thePanel.setLayout(new BorderLayout(0, 5));
		thePanel.add(new JLabel("Please select which restriction sites to search for"),
			BorderLayout.NORTH);
		thePanel.add(new JScrollPane(listBox), BorderLayout.CENTER);
		thePanel.add(buttonPanel, BorderLayout.EAST);

		defaultList();

		addButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						addListPopup();
					}
		});
		removeButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						removeListElement(listBox.getSelectedIndices());
					}
		});
		clearButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						clearList();
					}
		});
		defaultButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						defaultList();
					}
		});
	}

	public void addListPopup() {
		new RestrictionPopup(this);
	}

	public void addListElement(String name, String site) {
		enzymeList.put(name, new RestrictionEnzyme(name, site));
		listModel.clear();
		Object[] l = enzymeList.keySet().toArray();
		for(int i = 0; i < l.length; i++)
			listModel.addElement((String)l[i]);
	}

	public void removeListElement(int[] index_list) {
		for(int i = index_list.length-1; i >= 0; i--) {
			enzymeList.remove(listModel.elementAt(index_list[i]));
			listModel.removeElementAt(index_list[i]);
		}
	}
	public void clearList() {
		enzymeList.clear();
		listModel.clear();
	}

	public void defaultList() {
		enzymeList.clear();
		listModel.clear();
		for(int i = 0; i < nameList.length; i++) {
			enzymeList.put(nameList[i], new RestrictionEnzyme(nameList[i], siteList[i]));
			listModel.addElement(nameList[i]);
		}
	}

	public void actionPerformed(ActionEvent a) {
		String command = a.getActionCommand();

		if(command.equals(backString))
			listener.backClicked();
		else if(command.equals(nextString))
			listener.nextClicked(wildTypeDNASeq, mutantAminoSeq, true);
	}

	public void hasFocus(String results1, String results2, boolean defaultOutputFormat) {
		wildTypeDNASeq = results1;
		mutantAminoSeq = results2;
	}
}
