/*****************************************************************************\
*   SiteFind.java                                                             *
*                                                                             *
*   Copyright 2005, Paul M Evans                                              *
*                                                                             *
*   This file is part of SiteFind.                                            *
*                                                                             *
*   SiteFind is free software; you can redistribute it and/or modify          *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   SiteFind is distributed in the hope that it will be useful,               *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with Foobar; if not, write to the Free Software                     *
*   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA  *
\*****************************************************************************/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class SiteFind extends JApplet implements NextPanelListener {
	static int numPanels = 8;

	NextPanel panelList[];
	int curPanel;
	Map enzymeList;

	public void init() {
		panelList = new NextPanel[numPanels];
		curPanel = 0;
		enzymeList = new TreeMap();

		panelList[0] = new WelcomePanel(this);
		panelList[1] = new WildTypeDNAPanel(this);
		panelList[2] = new FrameSelectionPanel(this);
		panelList[3] = new MutantResiduePanel(this);
		panelList[4] = new RestrictionListPanel(this, enzymeList);
		panelList[5] = new ResultsFormatPanel(this);
		panelList[6] = new SearchStatusPanel(this, enzymeList, getWidth());
		panelList[7] = new ResultsPanel(this);
		getContentPane().add(panelList[0]);
	}

	public void nextClicked(String results1, String results2, boolean defaultOutputFormat) {
		getContentPane().remove(panelList[curPanel]);
		if(++curPanel >= numPanels)
			curPanel = 0;
		getContentPane().add(panelList[curPanel]);
		getContentPane().validate();
		getContentPane().repaint();
		panelList[curPanel].hasFocus(results1, results2, defaultOutputFormat);
	}

	public void backClicked() {
		getContentPane().remove(panelList[curPanel]);
		if(--curPanel < 0)
			curPanel = numPanels-1;
		getContentPane().add(panelList[curPanel]);
		getContentPane().validate();
		getContentPane().repaint();
	}
}
