%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Two-sample Hotelling test

function [p,T2,F,df1,df2,dF2] = tcwt_hotelling(X1,X2);

meanDiff = mean(X1) - mean(X2);

n1 = size(X1,1); n2 = size(X2,1);
df1 = length(meanDiff);
df2 = n1 + n2 - 2;
dF2 = n1 + n2 - df1 - 1;

CovPool = ( (n1-1)*cov(X1) + (n2-1)*cov(X2) )/df2; % Pooled Cov

% Alternative formula (Rencher 1998, p. 87):
% T2 = det(CovPool + n1*n2* meanDiff'*meanDiff / (n1+n2)) / det(CovPool) - 1;
% Does NOT work so well with nearly singular CovPool!

T2 = n1*n2 * meanDiff*(CovPool\meanDiff') / (n1+n2);

F = dF2 * T2 / df1 /df2;

p = 1  -fcdf(F,df1,dF2);


