%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Linear Discriminant Function (LDF)

function [ldTerp,ldMean] = tcwt_ldt(Verp,Scnd1,Scnd2);

n1 = size(Verp(Scnd1,:),1); mean1 = mean(Verp(Scnd1,:)); Cov1 = cov(Verp(Scnd1,:));
n2 = size(Verp(Scnd2,:),1); mean2 = mean(Verp(Scnd2,:)); Cov2 = cov(Verp(Scnd2,:));

CovPool = ( (n1-1)*Cov1 + (n2-1)*Cov2 )/(n1+n2-2); % Pooled Cov
ldTerp = CovPool\(mean1-mean2)'; % Linear Discriminant Function
ldMean = (mean1+mean2)*ldTerp/2;


