%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Principal Component Transform (PCT)

function [pcT,pcEV,pcVar] = tcwt_pct(C,Npc);

N=size(C,2);

if (~isscalar(Npc) || ~isnumeric(Npc) || ~isreal(Npc) || Npc<0 || Npc>N )
 error('Invalid PCA criterion <tcwt_help f2pc>.');
end

[pcT,pcEV]=eig(C);
pcVar=1;
if (N==1) return; end

pcEV=diag(pcEV)';
[pcEV,ipcEV]=sort(pcEV);
pcT=pcT(:,ipcEV);
pcEV=fliplr(pcEV);
pcT=fliplr(pcT);

totVar=sum(pcEV);
pcVar=zeros(1,N,'double');
for n=1:N,
  pcVar(n) = sum(pcEV(1:n))/totVar;
end

if ( Npc<=0 )
 Npc=sum(pcEV>mean(pcEV));
elseif ( (Npc>0) && (Npc<1) )
 Npc=sum(pcVar<Npc)+1;
elseif ( Npc==1 )
 Npc=N;
else
 Npc=floor(Npc);
end

pcEV = pcEV(1:Npc);
pcT = pcT(:,1:Npc);
pcVar = pcVar(Npc);


