%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Selection of Principal Components via Step-Down Test
%# (Rencher 1998, pp. 111, 177, 217)

function [VerpSD,pcTerpSD] = tcwt_stepdown(Verp,Scnd1,Scnd2,Npc,Alpha);

Npc0=1;
Backwards=1;

if (~isscalar(Alpha) || ~isnumeric(Alpha) || ~isreal(Alpha) || Alpha<0 || Alpha>1 )
 error('Invalid overall alpha level for the step-down test <tcwt_help x2ld>.');
end

pcTerp0 = tcwt_pct(cov(Verp),Npc0);

if ( Npc0==1 )
 pcTerp0=1;
else
 pcTerp0=tcwt_pct(cov(Verp),Npc0);
end
Verp = Verp*pcTerp0;
pcTerpSD = tcwt_pct(cov(Verp),Npc);
Verp = Verp*pcTerpSD;

if (Alpha>0)

 n1 = size(Verp(Scnd1,:),1); n2 = size(Verp(Scnd2,:),1);
 meanDiff = mean(Verp(Scnd1,:)) - mean(Verp(Scnd2,:)); % Mean Difference
 df1 = length(meanDiff); % Degrees of Freedom of Hotelling's T^2
 df2 = n1+n2-2; % Degrees of Freedom of Hotelling's T^2
 CovPool = ((n1-1)*cov(Verp(Scnd1,:)) + (n2-1)*cov(Verp(Scnd2,:)))/df2; % Pooled Cov

 OptimalSubset = true(1,df1);

 T2=zeros(1,df1,'double');
 for k=1:df1
  T2(k) = n1*n2 * meanDiff(1:k)*(CovPool(1:k,1:k)\meanDiff(1:k)') / (n1+n2);
 end
 T2 = sqrt( (df2 - [1:df1] + 1).*(T2 - [0,T2(1:df1-1)])./(df2 + [0,T2(1:df1-1)]) );

 for k=df1:-1:1
  if (Backwards==0)
   % Sidak Correction used instead of Bonferroni, because the tests are independent (Rencher 1998)
   OptimalSubset(k) = 2*(1 - tcdf(T2(k),df2-k+1)) < 1 - (1-Alpha)^(1/df1);
  else
   % Backward Selection with Adjustment of the Alpha Level after each Step
   OptimalSubset(k) = 2*(1 - tcdf(T2(k),df2-k+1)) < 1 - (1-Alpha)^(1/sum(OptimalSubset));
  end
 end

 VerpSD = Verp(:,OptimalSubset);
 pcTerpSD = pcTerp0*pcTerpSD(:,OptimalSubset);

end


