%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# DSNL = tcwt_dir2dsnl(dsPATH,filenamePattern) creates a DataSet Name List
%# (DSNL) from the output of a directory listing shell command executed
%# in the directory specified by dsPATH with filenamePattern as a parameter.
%#
%# INPUT VARIABLES
%#
%#   dsPATH             Full or relative path of the datasets' directory
%#
%#   filenamePattern    File name pattern with wildcards ('*' and/or '?')
%#
%# OUTPUT VARIABLES
%#
%#   DSNL       The DataSet Name List, a character array. Each row of DSNL
%#              is a DataSet Name (DSN). The DSNs are truncated names
%#              (basenames), i.e., dsPATH and all extensions are removed.

%       10        20        30        40        50        60        70        80

function dsnl = tcwt_dir2dsnl(dsPath,filenamePattern);

currentDir = pwd;
cd(dsPath);

if ispc()
 dos(['dir ' filenamePattern ' /b /on > _tmp.tmp']);
else
 unix(['ls -1 ' filenamePattern ' > _tmp.tmp']);
end

tmpfid=fopen('_tmp.tmp');
dsnl=[];
while ~feof(tmpfid),
 dsnl=[dsnl ; fgetl(tmpfid)];
end
fclose(tmpfid);
delete('_tmp.tmp');

dotpos=findstr(dsnl(1,:),'.');
if ~isempty(dotpos)
 dsnl=dsnl(:,1:dotpos(1)-1);
end

cd(currentDir);


