%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# XDSNL = tcwt_dsnl2xdsnl(prefix,DSNL,suffix) creates an eXtended
%# DataSet Name List (XDSNL) from an existing DataSet Name List
%# (DSNL) <tcwt_help dir2dsnl> by adding a prefix to the beginning
%# and a suffix to the end of each row (DSN) of DSNL.
%#
%# FUNCTION ARGUMENTS
%#
%#   DSNL     An existing DataSet Name List
%#
%#   prefix   The prexic added to each DSN
%#
%#   suffix   The suffix added to each DSN
%#
%# OUTPUT VARIABLES
%#
%#   XDSNL    The new eXtended DataSet Name List

%       10        20        30        40        50        60        70        80

function xdsnl = tcwt_dsnl2xdsnl(Prefix,dsnl,Suffix);

xdsnl = [repmat(Prefix,size(dsnl,1),1), dsnl, repmat(Suffix,size(dsnl,1),1)];


