%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# tcwt_f2merge(DSNL,suffixLIST,mergeSFX) merges two or more ERP datasets.
%#
%# The function iterates over DSNL and suffixLIST reading data from the
%# INPUT FILES and saving merged data to the corresponding OUTPUT FILES.
%#
%# FUNCTION ARGUMENTS
%#
%#   DSNL         DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%#
%#   suffixLIST = [sfx1; sfx2; ... ] Suffix List of datasets to be merged.
%#
%#   mergeSFX     The suffix of the resulting merger dataset.
%#
%# INPUT FILES          INPUT VARIABLES <tcwt_help t2f>
%#
%#   ./DSNsfx1.f.mat     Verp = Verp1, CIerp
%#   ./DSNsfx2.f.mat     Verp = Verp2, CIerp
%#   ...                 ...
%#
%#   ./DSNsfx1.ri0.mat   RIerp = RIerp1, DSNLpool
%#   ./DSNsfx2.ri0.mat   RIerp = RIerp2, DSNLpool
%#   ...                 ...
%#
%# OUTPUT FILES             OUTPUT VARIABLES
%#
%#   ./DSNmergeSFX.f.mat     Verp = [Verp1; Verp2; ... ]
%#                           CIerp
%#
%#   ./DSNmergeSFX.ri0.mat   RIerp = [RIerp1; RIerp2; ... ]
%#                           DSNLpool = [DSN mergeSFX] <tcwt_help f2pool>

%       10        20        30        40        50        60        70        80

function tcwt_f2merge(dsnl,suffixList,mergeSuffix);

rin='0';

O=tcwt_txt('\n');
O=[O,tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
O=[O,tcwt_txt('tcwt_f2merge: Merging Datasets\n')];
O=[O,tcwt_txt('-------------------------------------------------------------------------\n')];

for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 pVerp=[];
 pRIerp=[];
 O=[O,tcwt_txt('%s:',dsn)];
 for nn=1:size(suffixList,1)
  Suffix=suffixList(nn,:);
  load([dsn Suffix '.f.mat']);
  load([dsn Suffix '.ri' rin '.mat']);
  pVerp=[pVerp; Verp];
  pRIerp=[pRIerp; RIerp];
  O=[O,tcwt_txt(' *%s',Suffix)];
 end

 Verp=pVerp;
 RIerp=pRIerp;

 dsn = [dsn mergeSuffix];
 DSNLpool = dsn;

 save([dsn '.f.mat'],'Verp','CIerp');
 save([dsn '.ri' rin '.mat'],'RIerp','DSNLpool');
 O=[O,tcwt_txt(' >> *%s\n',mergeSuffix)];
end
O=[O,tcwt_txt('_________________________________________________________________________\n')];
