%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# tcwt_f2split(DSNL,trialrangeLIST,suffixLIST) splits ERP datasets
%#                                              into smaller subsets.
%#
%# The function iterates over DSNL reading data from the INPUT FILES,
%# splitting it according to trialrangeLIST, and saving the split data
%# to the corresponding OUTPUT FILES according to suffixLIST.
%#
%# FUNCTION ARGUMENTS
%#
%#   DSNL             DataSet Name List (DSN List) <tcwt_help dir2dsnl>
%#
%#   trialrangeLIST = [first1 last1; first2 last2;  ... ]   A list of
%#                    trial intervals defining the subsets into which
%#                    each dataset DSN will be split
%#
%#   suffixLIST   =   [sfx1; sfx2; ... ]    A list of suffixes
%#                    corresponding to the trial intervals defined
%#                    by trialrangeLIST to be added to each DSN to
%#                    name the corresponding subsets of ERP trails
%#
%# INPUT FILES            INPUT VARIABLES <tcwt_help t2f>
%#
%#   ./DSN.f.mat           Verp,CIerp
%#   ./DSN.ri0.mat         RIerp,DSNLpool
%#
%# OUTPUT FILES           OUTPUT VARIABLES
%#
%#   ./DSNsfx1.f.mat       Verp,CIerp
%#   ./DSNsfx2.f.mat       Verp,CIerp
%#   ...                   ...
%#
%#   ./DSNsfx1.ri0.mat     RIerp,DSNLpool
%#   ./DSNsfx2.ri0.mat     RIerp,DSNLpool
%#   ...                   ...

%       10        20        30        40        50        60        70        80

function tcwt_f2split(dsnl,trialRange,Suffix);

rin='0';

tcwt_txt('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n');
tcwt_txt('tcwt_f2split: Splitting Datasets into Subsets\n');
tcwt_txt('------------------------------------------------------------------------------\n');

for n=1:size(dsnl,1)
 dsn=dsnl(n,:);
 load([dsn '.f.mat']);
 load([dsn '.ri' rin '.mat']);
 Verp0 = Verp;
 RIerp0 = RIerp;

 for nn=1:size(trialRange,1)
  Verp = Verp0(trialRange(nn,1) : trialRange(nn,2) , :);
  RIerp = RIerp0(trialRange(nn,1) : trialRange(nn,2) , :);

  tcwt_txt('%s: trials %u to %u --> %s%s\n', dsn,trialRange(nn,1),trialRange(nn,2),dsn,Suffix(nn,:));
  save([dsn Suffix(nn,:) '.f.mat'],'Verp','CIerp');
  save([dsn Suffix(nn,:) '.ri' rin '.mat'],'RIerp','DSNLpool');
 end
end
tcwt_txt('------------------------------------------------------------------------------\n');


