%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Sums of Squares (SS) for subsequent t-CWT
%# cwVerpVar = ( cwVerpSS - Ntr*cwVerpMean^2 ) / ( Ntr - 1 )

function [cwVerpSS] = tcwt_cwtss(Verp,CIerp,pcTerp,cwTerp,NcwMax,countN);

Verp = Verp*(pcTerp*pcTerp');

Ntr=size(Verp,1);
if ( NcwMax>Ntr || NcwMax==0 )
 NcwMax=Ntr;
end
Ch = unique(CIerp(1,:));
Nch = length(Ch);
NcwPt = size(cwTerp,2);
cwVerpSS = zeros(1, Nch*NcwPt, 'double');
for n=1:Nch
 if (countN) tcwt_txt('%3u/%3u',Ch(n),Ch(Nch)); end
 Sch = CIerp(1,:)==Ch(n);
 SS=0;
 for nn=1:NcwMax:Ntr
  Nblock = min(nn+NcwMax-1,Ntr);
  cwVerp = Verp(nn:Nblock,Sch)*cwTerp;
  if (size(cwVerp,1)==1)
   SS = SS + cwVerp.*cwVerp;
  else
   SS = SS + sum(cwVerp.*cwVerp);
  end
 end
 cwVerpSS( (n-1)*NcwPt + 1 : n*NcwPt ) =  SS;
 if (countN) tcwt_txt('\b\b\b\b\b\b\b'); end
end
