%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Convolution transformation matrix

function C = tcwt_convmat(Nx,v,dNx);

v=v(:);
Nv=length(v);
Nxl=Nx+2*dNx;
C=repmat([v;zeros(Nxl-Nv+1,1)],Nxl-Nv+1,1);
C=C(1:Nxl*(Nxl-Nv+1));
C=reshape(C,Nxl,Nxl-Nv+1);
C=C(dNx+1:dNx+Nx,:);


