%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Starts a t-CWT Job <tcwt_help main>

function [scrFILE,prmFILE,varFILE,asciiPath,tmatPath,logFILE,txtO] = tcwt_job(jobNAME);

txtO=sprintf('\n');
txtO=[txtO,sprintf('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n')];
txtO=[txtO,sprintf('tcwt_job: Starting t-CWT Job\n')];
txtO=[txtO,sprintf('---------------------------------------------------------------------------\n')];

L = length(jobNAME);
[mI,mF] = regexp(jobNAME,'^[a-z][a-z0-9]*_[a-z0-9]+_[a-z0-9]+_[a-z0-9]+$');

if ( isempty(mI) || isempty(mF) || length(mI)~=1 || length(mF)~=1 || mI~=1 || mF~=L )
 error('Invalid job name.');
end

uPos = findstr(jobNAME,'_');

prjNAME = jobNAME(1:uPos(1)-1);
scrNAME = jobNAME(uPos(1)+1:uPos(2)-1);
prmNAME = jobNAME(uPos(2)+1:uPos(3)-1);
varNAME = jobNAME(uPos(3)+1:L);


if ispc() pslash = '\'; else pslash = '/'; end
tcwt_work;
if ~exist(prjNAME,'dir') error('Project directory does not exist.'); end
cd(prjNAME);

asciiPath = ['..' pslash '_ascii'];
tmatPath  = ['..' pslash '_tmat' ];
if ~exist('_tmat','dir') mkdir('_tmat'); end

jobDIR = [prmNAME '_' varNAME];
if ~exist(jobDIR,'dir') mkdir(jobDIR); end
cd(jobDIR);
jobDIR = pwd;

txtO=[txtO,sprintf('Project name:  %s\n', prjNAME)];
txtO=[txtO,sprintf('Job name:      %s\n', jobNAME)];
txtO=[txtO,sprintf('Job directory: %s\n', jobDIR )];
txtO=[txtO,sprintf('---------------------------------------------------------------------------\n')];

scrFILE = [prjNAME '_' scrNAME];
prmFILE = [prjNAME '_' prmNAME];
varFILE = [prjNAME '_' varNAME];

txtO=[txtO,sprintf('Job script file:          %s.m\n', scrFILE)];
txtO=[txtO,sprintf('Job input parameter file: %s.m\n', prmFILE)];
txtO=[txtO,sprintf('Job input variable file:  %s.m\n', varFILE)];
txtO=[txtO,sprintf('---------------------------------------------------------------------------\n')];

scrFILEcopy = ['./_A_scr_' scrNAME '.m'];
prmFILEcopy = ['./_A_prm_' prmNAME '.m'];
varFILEcopy = ['./_A_var_' varNAME '.m'];

copyfile(which(scrFILE), scrFILEcopy);
copyfile(which(prmFILE), prmFILEcopy);
copyfile(which(varFILE), varFILEcopy);

txtO=[txtO,sprintf('Copied: %s.m  >  %s\n',scrFILE,scrFILEcopy)];
txtO=[txtO,sprintf('Copied: %s.m  >  %s\n',prmFILE,prmFILEcopy)];
txtO=[txtO,sprintf('Copied: %s.m  >  %s\n',varFILE,varFILEcopy)];
txtO=[txtO,sprintf('---------------------------------------------------------------------------\n')];

logFILE = ['./_A_run_' scrNAME '.log'];
txtO=[txtO,sprintf('Text output will be saved to %s\n',logFILE)];
txtO=[txtO,sprintf('___________________________________________________________________________\n')];
