%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.


%# logarithmic grid for logcwt

% Ntp   -- number of original time points
% smin  -- minimal scale
% smax  -- maximal scale
% Nsppo -- number of scale points per octave
% Ntpps -- number of time points per scale 

function logGrid = tcwt_loggrid(Ntp,smin,smax,logGridR);

Nsppo=logGridR; Ntpps=logGridR;
logGrid=[];
dilate=smax/smin;
Nspl=ceil(Nsppo*log2(dilate));
slog = tcwt_logtime(smin,smax,dilate,Nspl);
for sl=slog,
  Ntpl=ceil(Ntpps*(Ntp-1)/sl)+1;
  tl=[0:Ntpl-1]*(Ntp-1)/(Ntpl-1);
  logGrid=[logGrid, [sl*ones(1,Ntpl); tl] ];
end

% plot(logGrid(2,:),logGrid(1,:),'.r')

