%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Creates an N-point logarthmic scale starting at time ti
%# and ending at time tf. dilate is the contraction coefficient.
%# The contraction is a linear function of the time t:
%#
%# dt'/dt = 1 / (1 + (dilate-1)*(t-ti)/(tf-ti)),
%#
%# which yields:
%#
%# (dilate-1)*(t'-ti)/(tf-ti) = ln(1 + (dilate-1)*(t-ti)/(tf-ti)).
%#
%# At t=ti, dt'/dt=1; at t=tf, dt'/dt=1/dilate.
%#
%# If dilate=1 there is no contraction at all.

function [tlog,Llog] = tcwt_logtime(ti,tf,dilate,Nl,dt);

if ti>=tf error('First parameter ti and second parameter tf must be: ti < tf.'); end
if dilate<1 error('Third parameter dilate must be: dilate >= 1.'); end
if Nl<2 error('Fourth parameter Nl must be: Nl >= 2.'); end

L=tf-ti;
lambda=(dilate-1)/L;

if lambda~=0
  Llog = log(1+lambda*L)/lambda;
else
  Llog = L;
end

tlog = [0:Nl-1]*Llog/(Nl-1);
if nargin > 4
  tlog = tlog + dt*Llog/L;
end

if lambda~=0
  tlog = ti + (exp(lambda*tlog) - 1)/lambda;
else
  tlog = ti + tlog;
end


