%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# Tukey window function

function winTerp = tcwt_wintukey(Time,fadeInOut);

MinAmp = 0.001; % Allow inverse transform

N=length(Time);
ti = Time(1);
tf = Time(N) + Time(2) - Time(1);

if (fadeInOut(1)>0)
 FadeInTime=Time(Time < ti+fadeInOut(1));
 winFadeIn=(1-cos(pi*(FadeInTime-ti)/fadeInOut(1)))/2;
else winFadeIn=[]; end
if (fadeInOut(2)>0)
 FadeOutTime=Time(Time > tf-fadeInOut(2));
 winFadeOut=(1-cos(pi*(tf-FadeOutTime)/fadeInOut(2)))/2;
else winFadeOut=[]; end

winConst=ones(1,N-length(winFadeIn)-length(winFadeOut));

winTerp=[winFadeIn,winConst,winFadeOut];
winTerp=MinAmp+(1-MinAmp)*winTerp; % Allow inverse transform
winTerp=diag(winTerp);


