%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# The cxyFILE contains the integer X-Y-coordinates of the EEG channels in
%# the subplot arrays created by the plotting functions <tcwt_help f2plot>.
%#
%# VARIABLE:  ChannelXY = [ x1 y1 s1; x2 y2 s2; ... xN yN sN; ... ],  where
%#
%#  xN is the X-coordinate of the subplot corresponding to the Nth channel;
%#  yN is the Y-coordinate of the subplot corresponding to the Nth channel;
%#  sN = 1 or 0, defines whether channel N is included in the plot or not.
%#
%# The channel number N of each EEG channel is defined by ist corresponding
%# row number in the character array defined by the job input parameter
%# ChannelList <tcwt_help prm>. A channel N that is marked as discarded
%# in ChannelList must have sN = 0 in ChannelXY.

%       10        20        30        40        50        60        70        80

ChannelXY = [ ...
NaN NaN    0 ; ... % Ch1  = VEOG
NaN NaN    0 ; ... % Ch2  = HEOG
  0   1    1 ; ... % Ch3  = FZ
  0   0    1 ; ... % Ch4  = CZ
  0  -1    1 ; ... % Ch5  = PZ
 -1  -1    1 ; ... % Ch6  = P3
  1  -1    1 ; ... % Ch7  = P4
 -1   0    1 ; ... % Ch8  = C3
  1   0    1 ; ... % Ch9  = C4
 -1   1    1 ; ... % Ch10 = F3
  1   1    1 ; ... % Ch11 = F4
[]];
