%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# A t-CWT job script prjNAME_scrNAME is called from the main
%# job script prjNAME_scrNAME_prmNAME_varNAME <tcwt_help main>.
%# The job script is executed in the project directory
%# tcwtWORK/prjNAME/prmNAME_varNAME, where tcwtWORK
%# denotes the t-CWT work path <tcwt_help install>
%#
%# A job script is mostly a list of function calls to t-CWT functions, with
%# source files tcwtROOT/func/*.m (tcwtROOT denotes the t-CWT root path).
%#
%# t-CWT functions using one or more job constants access them by loading
%# the file './_A_const.mat' <tcwt_help prm2mat>. Job constants are computed
%# and stored in './_A_const.mat' by the main script before calling the
%# job script. They are computed from the job input parameters defined
%# by the input parameter script prjNAME_prmNAME <tcwt_help prm>.
%#
%# The main script calls also the input variable script prjNAME_varNAME.
%# Unlike job input parameters, job input variables are passed to t-CWT
%# functions directly through the function arguments <tcwt_help var>.
%#
%# The main script saves a copy of the job script file
%# tcwtROOT/jobs/prjNAME_scrNAME.m in './_A_scr_scrNAME.m'
%# (i.e. in tcwtWORK/prjNAME/prmNAME_varNAME/_A_scr_scrNAME.m).
%#
%# Create a new job script prjNAME_scrNAME by simply copying
%# the demo job script file tcwtROOT/demo/tcwt_scr.m to
%# tcwtROOT/jobs/prjNAME_scrNAME.m and editing the copy.

%       10        20        30        40        50        60        70        80

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist(asciiPath,'dir')
 dsnl = tcwt_dir2dsnl(asciiPath, ['*' CndName(1,:) '.*']);

 dsnl1 = tcwt_dsnl2xdsnl('',dsnl,CndName(1,:));
 dsnl2 = tcwt_dsnl2xdsnl('',dsnl,CndName(2,:));

 tcwt_ascii2tmat(dsnl1,Cnd(1))
 tcwt_ascii2tmat(dsnl2,Cnd(2))
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
dsnl = tcwt_dir2dsnl(tmatPath, ['*' CndName(1,:) '.t.mat']);

dsnl1 = tcwt_dsnl2xdsnl('',dsnl,CndName(1,:));
dsnl2 = tcwt_dsnl2xdsnl('',dsnl,CndName(2,:));

dsnlA = tcwt_dsnl2xdsnl('',dsnl,'_a');
dsnlB = tcwt_dsnl2xdsnl('',dsnl,'_b');
dsnlC = tcwt_dsnl2xdsnl('',dsnl,'_c');

tcwt_t2f([dsnl1;dsnl2]);
tcwt_f2merge(dsnl,CndName,'');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

disp('           *********************');
disp('           *        GROUP      *');
disp('           *********************');

tcwt_f2pool(dsnl,'_pool');
tcwt_f2pc('_pool',NpcG,NstdG,MinGoodG);
tcwt_f2cwss('_pool');
tcwt_pc2cnd2ri(0,'_pool',Cnd,NstdG,MinGoodG2);
tcwt_f2x(0,'_pool',Cnd);
tcwt_x2ld(0,'_pool',Cnd,NpcG,sdAlpha);

disp(' ');
disp('      < GROUP Hold-Out: 1 Dataset Out >');
disp('        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^');

tcwt_ri2ri1out('_pool');
tcwt_pc2cnd2ri(1,'_pool',Cnd,NstdG,MinGoodG2);
tcwt_f2x(1,'_pool',Cnd);
tcwt_x2ld(1,'_pool',Cnd,NpcG,sdAlpha);

disp('           *********************');
disp('           *     INDIVIDUAL    *');
disp('           *********************');

tcwt_f2pc(dsnl,NpcI,NstdI,0);
tcwt_f2cwss(dsnl);
tcwt_pc2cnd2ri(0,dsnl,Cnd,NstdI,0);
tcwt_f2x(0,dsnl,Cnd);
tcwt_x2ld(0,dsnl,Cnd,NpcI,sdAlpha);
tcwt_f2stats(0,dsnl,dsnl,'_all',Cnd,0);
tcwt_f2stats(0,dsnl,dsnl,'_all',Cnd,1);
tcwt_f2stats(1,'_pool',dsnl,'_all',Cnd,0);
tcwt_f2stats(1,'_pool',dsnl,'_all',Cnd,1);

disp(' ');
disp('     < INDIVIDUAL Split-Half >');
disp('       ^^^^^^^^^^^^^^^^^^^^^');

tcwt_f2split(dsnl1,[1 121; 122 242; 186 242],['_a';'_b';'_c']);
tcwt_f2split(dsnl2,[1  19;  20  38;  30  38],['_a';'_b';'_c']);

tcwt_f2merge(dsnl, [CndName ['_a';'_a']], '_a');
tcwt_f2merge(dsnl, [CndName ['_b';'_b']], '_b');
tcwt_f2merge(dsnl, [CndName ['_c';'_c']], '_c');

tcwt_f2pc(dsnlA,NpcI,NstdI,0);
tcwt_f2cwss(dsnlA);
tcwt_pc2cnd2ri(0,dsnlA,Cnd,NstdI,0);
tcwt_f2x(0,dsnlA,Cnd);
tcwt_x2ld(0,dsnlA,Cnd,NpcI,sdAlpha);
tcwt_f2stats(0,dsnlA,dsnlB,'_all.split-half',Cnd,0);
tcwt_f2stats(0,dsnlA,dsnlB,'_all.split-half',Cnd,1);
tcwt_f2stats(0,dsnlA,dsnlC,'_all.split-half-57-9',Cnd,0);
tcwt_f2stats(0,dsnlA,dsnlC,'_all.split-half-57-9',Cnd,1);

disp(' ');
disp('     < INDIVIDUAL Hold-Out: 1 Single Trial Out >');
disp('       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^');

tcwt_f2holdout(dsnl,'_all',Cnd,NstdI,0,NpcI,sdAlpha);

return

%%% LaTeX output %%%%%%%%%%
LaTeXaPriori=0; tcwt_latex;
LaTeXaPriori=1; tcwt_latex;
%%% Plots %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tcwt_f2plot('_pool',cxyFile,Cnd,lineWidth2,lineRGB2,lineWidth,lineRGB)
tcwt_ld2plot('_pool',cxyFile,-3,lineWidth,lineRGB)

tcwt_f2plot('GIM',cxyFile,Cnd,lineWidth2,lineRGB2,lineWidth,lineRGB)
tcwt_ld2plot('GIM',cxyFile,-2,lineWidth,lineRGB)

%  tcwt_f2plot(dsnl,cxyFile,Cnd,lineWidth2,lineRGB2,lineWidth,lineRGB)
%  tcwt_ld2plot(dsnl,cxyFile,-1,lineWidth,lineRGB)
