%
% t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".
%

% This file is part of t-CWT.
%
% t-CWT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published
% by the Free Software Foundation, either version 3 of the License,
% or (at your option) any later version.
%
% t-CWT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty
% of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
% See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with t-CWT; see the file COPYING or the file tcwt_gpl.m
% If not, see <http://www.gnu.org/licenses/>.

%# tcwt_path adds the t-CWT source code directory tree to the search path
%# and sets the t-CWT work path (where data is to be stored and processed).

if ~exist('tcwtROOT') % for remote execution as a PBS job
 tcwtROOT = [getenv('TMPDIR') '/t-CWT'];
 tcwtWORK = [getenv('TMPDIR') '/t-CWT.work'];
 cd(tcwtROOT);
end

if ispc() pslash = '\'; else pslash = '/'; end

path(path,   tcwtROOT );
path(path, [ tcwtROOT pslash 'jobs' ]);
path(path, [ tcwtROOT pslash 'demo' ]);
path(path, [ tcwtROOT pslash 'func' ]);
path(path, [ tcwtROOT pslash 'func' pslash 'terps' ]);
path(path, [ tcwtROOT pslash 'func' pslash 'stats' ]);
path(path, [ tcwtROOT pslash 'func' pslash 'tools' ]);

tcwtWORK = sprintf('cd(''%s'');',tcwtWORK);
tcwtWORK = sprintf('%s\r\n\r\n%s\r\n','%# tcwt_work is set by tcwt_path at startup.',tcwtWORK);
tcwt_txtsave('tcwt_work.m',tcwtWORK);

clear tcwtROOT tcwtWORK pslash
tcwt_work;

disp('t-CWT Copyright (C) 2003, 2014-2015 Vladimir Bostanov. Type "tcwt_help".');
