#!/usr/bin/perl
# This script creates a dummy .psl format

#($match,$mism,$repm,$ncnt,$qins, $qinsbase, $tins, $tinsbase, $strand, $qname, $qsize,$qstart, $qend, $tname, $tsize, $tstart, $tend, $blkcnt, $blksize, $qstarts,$tstarts)
#50      0       0       0       0       0       0       0       +       cg00025991      50      0       50      chr10   13553 4747    736576  736626  1       50,     0,      736576,
#HSAP0406S00000003       1               18364   19473       

$PGM = $0;                      
##################
$usage = <<USAGE;		# usage message
  USAGE:
	$PGM  -i <feature file name> -c <4 or 5>  -o <output file name> 
	                     
	-i <feature file>	 file containing feature information in 4 or 5 column format
				 Following format is required:
                         "FeatureName Chromosome Start End" or "FeatureName Chromosome Strand Start End"
	-c <no. of columns>  enter 4 or 5 
				   
	-o <output file name> 

	-h 	Prints out the USAGE message.

	IMP. NOTE: This program outputs STDOUT 

        Copyright
        (2009) Queensland Institute of Medical Research
        All Rights Reserved.
        Author: Sonika Tyagi 
USAGE

#DEFAULTS
$strand='+';


$nargs = 6;			# number of required args
if ($#ARGV+1 < $nargs) { &print_usage("$usage", 1); }

# get input arguments
while ($#ARGV >= 0) {
  $_ = shift;
  if ($_ eq "-h") {				# help
    &print_usage("$usage", 0);
  } elsif ($_ eq "-i") {			# feature file name
    $infile= shift;
  } elsif ($_ eq "-c") {			# number of columns in the feature file
    $no_of_column = shift;
  } elsif ($_ eq "-o") {			# output file name
    $outfile = shift;
  } else {
    &print_usage("$usage", 1);
  }
} #ends while

while(<STDIN>){
  chomp;
  if($no_of_coulmn ==4) {
   ($qname,$chr,$tstart, $tend) = split (/\s+/,$_);
  } elsif($no_of_column ==5){
    ($qname,$chr,$strand,$tstart, $tend) = split (/\s+/,$_);
  } else {
    die("ERROR!! only 4 or 5 column format can be read in\n");
  }
  $blksize = $tend-$tstart;
  print "50\t0\t0\t0\t0\t0\t0\t0\t$strand\t$qname\t50\t0\t50\tchr$chr\t135534747\t$tstart\t$tend\t1\t$blksize,\t0,\t$tstart,\n";
  #print "$qname,$chr,$tstart,$tend\n"; exit;

}#end while    



sub print_usage {
  my($usage, $status) = @_;
  if (-c STDOUT) {			# standard output is a terminal
    open(C, "| more");
    print C $usage;
    close C;
  } else {				# standard output not a terminal
    print STDERR $usage;
  }
  exit $status;
}
