//WinBLAST is a graphical front-end for NCBI BLAST.
//Copyright (C) 2003 Alan Li, alanli@bioinformatics.org
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;

namespace WinBLAST
{
	/// <summary>
	/// Summary description for WinBLAST.
	/// </summary>
	public class WinBLAST : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.NumericUpDown expectedValue;
		private System.Windows.Forms.TextBox dbLocation;
		private System.Windows.Forms.Button blastButton;
		private System.Windows.Forms.Button aboutButton;
		private System.Windows.Forms.Button fileDialogButton;
		private System.Windows.Forms.ComboBox programName;
		private System.Windows.Forms.RadioButton queryFileBtn;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.RadioButton inputSeqBtn;
		private System.Windows.Forms.Button fileDialogButton1;
		private System.Windows.Forms.TextBox queryLocation;
		private System.Windows.Forms.TextBox inputSequence;
		private System.Windows.Forms.Label label4;
		internal System.Windows.Forms.ComboBox alignmentView;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Button closeButton;
		private System.ComponentModel.IContainer components;
		private Databases m_databasesForm = null;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.NumericUpDown numOfAlignments;
		private System.Windows.Forms.CheckBox htmlCheckBox;
		private static string sm_dbFile = Environment.CurrentDirectory + "/_BlastDatabases";
		private static Random sm_random = new Random();

		private WinBLAST()
		{	
			//
			// Required for Windows Form Designer support
			//
			showSplashScreen();
			InitializeComponent();

			// set alignment view to default value: "Analysis"
			alignmentView.SelectedIndex = 0;
		}

		private void showSplashScreen()
		{
			// show the splash screen for 2 seconds
			this.Cursor = Cursors.WaitCursor;
			SplashScreen splashScreen = new SplashScreen();
			splashScreen.Show();
			Thread.Sleep( 2000 );
			splashScreen.Hide();
			this.Cursor = Cursors.Arrow;
		}

		private void saveDataSetToFile( DataSet dataSet )
		{
			if( dataSet == null )
				return;

			Stream stream = File.Open( sm_dbFile, FileMode.Create );
			BinaryFormatter binaryFormatter = new BinaryFormatter();
			binaryFormatter.Serialize( stream, dataSet );
			stream.Close();
		}

		private DataSet loadDataSetFromFile()
		{
			if( ! File.Exists( sm_dbFile ) )
				return null;

			Stream stream = File.Open( sm_dbFile, FileMode.Open );
			BinaryFormatter binaryFormatter = new BinaryFormatter();
			DataSet ret = (DataSet) binaryFormatter.Deserialize( stream );
			stream.Close();
			return ret;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(WinBLAST));
			this.blastButton = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.numOfAlignments = new System.Windows.Forms.NumericUpDown();
			this.label5 = new System.Windows.Forms.Label();
			this.fileDialogButton = new System.Windows.Forms.Button();
			this.dbLocation = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.expectedValue = new System.Windows.Forms.NumericUpDown();
			this.label2 = new System.Windows.Forms.Label();
			this.programName = new System.Windows.Forms.ComboBox();
			this.alignmentView = new System.Windows.Forms.ComboBox();
			this.label4 = new System.Windows.Forms.Label();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.aboutButton = new System.Windows.Forms.Button();
			this.queryFileBtn = new System.Windows.Forms.RadioButton();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.inputSeqBtn = new System.Windows.Forms.RadioButton();
			this.fileDialogButton1 = new System.Windows.Forms.Button();
			this.queryLocation = new System.Windows.Forms.TextBox();
			this.inputSequence = new System.Windows.Forms.TextBox();
			this.closeButton = new System.Windows.Forms.Button();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.htmlCheckBox = new System.Windows.Forms.CheckBox();
			this.groupBox1.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numOfAlignments)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.expectedValue)).BeginInit();
			this.groupBox2.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.SuspendLayout();
			// 
			// blastButton
			// 
			this.blastButton.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.blastButton.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.blastButton.Location = new System.Drawing.Point(32, 416);
			this.blastButton.Name = "blastButton";
			this.blastButton.Size = new System.Drawing.Size(88, 32);
			this.blastButton.TabIndex = 14;
			this.blastButton.Text = "BLAST!";
			this.blastButton.Click += new System.EventHandler(this.blastButton_Click);
			// 
			// label1
			// 
			this.label1.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.label1.Location = new System.Drawing.Point(24, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(88, 21);
			this.label1.TabIndex = 2;
			this.label1.Text = "Program name:";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.numOfAlignments,
																					this.label5,
																					this.fileDialogButton,
																					this.dbLocation,
																					this.label3,
																					this.expectedValue,
																					this.label2,
																					this.label1,
																					this.programName});
			this.groupBox1.Location = new System.Drawing.Point(8, 4);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(376, 104);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Program Options";
			// 
			// numOfAlignments
			// 
			this.numOfAlignments.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.numOfAlignments.Location = new System.Drawing.Point(232, 40);
			this.numOfAlignments.Maximum = new System.Decimal(new int[] {
																			1000,
																			0,
																			0,
																			0});
			this.numOfAlignments.Name = "numOfAlignments";
			this.numOfAlignments.Size = new System.Drawing.Size(80, 20);
			this.numOfAlignments.TabIndex = 3;
			this.numOfAlignments.Value = new System.Decimal(new int[] {
																		  250,
																		  0,
																		  0,
																		  0});
			// 
			// label5
			// 
			this.label5.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.label5.Location = new System.Drawing.Point(232, 16);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(104, 21);
			this.label5.TabIndex = 10;
			this.label5.Text = "# of Alignments:";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// fileDialogButton
			// 
			this.fileDialogButton.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.fileDialogButton.Image = ((System.Drawing.Bitmap)(resources.GetObject("fileDialogButton.Image")));
			this.fileDialogButton.Location = new System.Drawing.Point(336, 72);
			this.fileDialogButton.Name = "fileDialogButton";
			this.fileDialogButton.Size = new System.Drawing.Size(32, 24);
			this.fileDialogButton.TabIndex = 5;
			this.fileDialogButton.Click += new System.EventHandler(this.fileDialogButton_Click);
			// 
			// dbLocation
			// 
			this.dbLocation.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.dbLocation.Location = new System.Drawing.Point(128, 72);
			this.dbLocation.Name = "dbLocation";
			this.dbLocation.Size = new System.Drawing.Size(208, 20);
			this.dbLocation.TabIndex = 4;
			this.dbLocation.Text = "";
			// 
			// label3
			// 
			this.label3.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.label3.Location = new System.Drawing.Point(8, 72);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(104, 21);
			this.label3.TabIndex = 5;
			this.label3.Text = "Database Name:";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// expectedValue
			// 
			this.expectedValue.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.expectedValue.DecimalPlaces = 1;
			this.expectedValue.Location = new System.Drawing.Point(128, 40);
			this.expectedValue.Name = "expectedValue";
			this.expectedValue.Size = new System.Drawing.Size(88, 20);
			this.expectedValue.TabIndex = 2;
			this.expectedValue.Value = new System.Decimal(new int[] {
																		10,
																		0,
																		0,
																		0});
			// 
			// label2
			// 
			this.label2.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.label2.Location = new System.Drawing.Point(120, 16);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(104, 21);
			this.label2.TabIndex = 3;
			this.label2.Text = "Expectation Value:";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// programName
			// 
			this.programName.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.programName.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.programName.Items.AddRange(new object[] {
															 "blastp",
															 "blastn",
															 "blastx",
															 "tblastn",
															 "tblastx"});
			this.programName.Location = new System.Drawing.Point(32, 40);
			this.programName.Name = "programName";
			this.programName.Size = new System.Drawing.Size(72, 21);
			this.programName.TabIndex = 1;
			// 
			// alignmentView
			// 
			this.alignmentView.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.alignmentView.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.alignmentView.ForeColor = System.Drawing.SystemColors.WindowFrame;
			this.alignmentView.Items.AddRange(new object[] {
															   "Pairwise",
															   "Master-slave, show identities",
															   "Master-slave, no identities",
															   "Flat master-slave, show identities",
															   "Flat master-slave, no identities",
															   "Master-slave, no identities, blunt ends",
															   "Flat master-slave, no identities, blunt ends"});
			this.alignmentView.Location = new System.Drawing.Point(128, 16);
			this.alignmentView.Name = "alignmentView";
			this.alignmentView.Size = new System.Drawing.Size(240, 21);
			this.alignmentView.TabIndex = 12;
			// 
			// label4
			// 
			this.label4.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.label4.Location = new System.Drawing.Point(16, 16);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(88, 21);
			this.label4.TabIndex = 8;
			this.label4.Text = "Alignment View:";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// aboutButton
			// 
			this.aboutButton.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.aboutButton.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.aboutButton.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.aboutButton.Location = new System.Drawing.Point(272, 416);
			this.aboutButton.Name = "aboutButton";
			this.aboutButton.Size = new System.Drawing.Size(88, 32);
			this.aboutButton.TabIndex = 16;
			this.aboutButton.Text = "About";
			this.aboutButton.Click += new System.EventHandler(this.aboutButton_Click);
			// 
			// queryFileBtn
			// 
			this.queryFileBtn.Anchor = System.Windows.Forms.AnchorStyles.Top;
			this.queryFileBtn.Checked = true;
			this.queryFileBtn.Location = new System.Drawing.Point(16, 16);
			this.queryFileBtn.Name = "queryFileBtn";
			this.queryFileBtn.Size = new System.Drawing.Size(112, 24);
			this.queryFileBtn.TabIndex = 6;
			this.queryFileBtn.TabStop = true;
			this.queryFileBtn.Text = "Query File:";
			this.queryFileBtn.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.inputSeqBtn,
																					this.queryFileBtn,
																					this.fileDialogButton1,
																					this.queryLocation,
																					this.inputSequence});
			this.groupBox2.Location = new System.Drawing.Point(8, 116);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(376, 212);
			this.groupBox2.TabIndex = 7;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Input";
			// 
			// inputSeqBtn
			// 
			this.inputSeqBtn.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.inputSeqBtn.Location = new System.Drawing.Point(16, 48);
			this.inputSeqBtn.Name = "inputSeqBtn";
			this.inputSeqBtn.Size = new System.Drawing.Size(112, 24);
			this.inputSeqBtn.TabIndex = 9;
			this.inputSeqBtn.Text = "Input Sequence:";
			this.inputSeqBtn.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// fileDialogButton1
			// 
			this.fileDialogButton1.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.fileDialogButton1.Image = ((System.Drawing.Bitmap)(resources.GetObject("fileDialogButton1.Image")));
			this.fileDialogButton1.Location = new System.Drawing.Point(336, 16);
			this.fileDialogButton1.Name = "fileDialogButton1";
			this.fileDialogButton1.Size = new System.Drawing.Size(32, 23);
			this.fileDialogButton1.TabIndex = 8;
			this.fileDialogButton1.Click += new System.EventHandler(this.fileDialogButton1_Click);
			// 
			// queryLocation
			// 
			this.queryLocation.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.queryLocation.Location = new System.Drawing.Point(128, 16);
			this.queryLocation.Name = "queryLocation";
			this.queryLocation.Size = new System.Drawing.Size(208, 20);
			this.queryLocation.TabIndex = 7;
			this.queryLocation.Text = "";
			this.queryLocation.TextChanged += new System.EventHandler(this.queryLocation_TextChanged);
			this.queryLocation.MouseUp += new System.Windows.Forms.MouseEventHandler(this.queryLocation_MouseUp);
			// 
			// inputSequence
			// 
			this.inputSequence.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.inputSequence.Location = new System.Drawing.Point(128, 48);
			this.inputSequence.Multiline = true;
			this.inputSequence.Name = "inputSequence";
			this.inputSequence.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.inputSequence.Size = new System.Drawing.Size(240, 152);
			this.inputSequence.TabIndex = 10;
			this.inputSequence.Text = "";
			this.inputSequence.TextChanged += new System.EventHandler(this.inputSequence_TextChanged);
			this.inputSequence.MouseUp += new System.Windows.Forms.MouseEventHandler(this.inputSequence_MouseUp);
			// 
			// closeButton
			// 
			this.closeButton.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.closeButton.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.closeButton.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.closeButton.Location = new System.Drawing.Point(152, 416);
			this.closeButton.Name = "closeButton";
			this.closeButton.Size = new System.Drawing.Size(88, 32);
			this.closeButton.TabIndex = 15;
			this.closeButton.Text = "Close";
			this.closeButton.Click += new System.EventHandler(this.closeButton_Click);
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.htmlCheckBox,
																					this.label4,
																					this.alignmentView});
			this.groupBox3.Location = new System.Drawing.Point(8, 336);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(376, 72);
			this.groupBox3.TabIndex = 11;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Output";
			// 
			// htmlCheckBox
			// 
			this.htmlCheckBox.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.htmlCheckBox.Location = new System.Drawing.Point(24, 40);
			this.htmlCheckBox.Name = "htmlCheckBox";
			this.htmlCheckBox.Size = new System.Drawing.Size(120, 24);
			this.htmlCheckBox.TabIndex = 13;
			this.htmlCheckBox.Text = "Html:";
			// 
			// WinBLAST
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(394, 455);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.groupBox3,
																		  this.closeButton,
																		  this.aboutButton,
																		  this.blastButton,
																		  this.groupBox1,
																		  this.groupBox2});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "WinBLAST";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "WinBlast v.0.1.5";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.WinBLAST_Closing);
			this.groupBox1.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numOfAlignments)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.expectedValue)).EndInit();
			this.groupBox2.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new WinBLAST());
		}

		
		private void blastButton_Click(object sender, System.EventArgs e)
		{
			WinBLASTWorker worker = new WinBLASTWorker( this );
			worker.setProgramName( programName.Text );
			worker.setExpectedValue( expectedValue.Value );
			worker.setDBName( dbLocation.Text );
			worker.setAlignmentView( alignmentView.SelectedIndex );
			worker.setNumOfAlignments( numOfAlignments.Value );
			worker.setIsFileQuery( queryFileBtn.Checked );
			if( queryFileBtn.Checked )
				worker.setQuery( queryLocation.Text );
			else
				worker.setQuery( inputSequence.Text );

			if( htmlCheckBox.Checked )
				worker.setIsHtml( true );

			if( ! worker.runBlast() )
			{
				Warning warningDialog = new Warning();
				warningDialog.setWarningText( worker.getError() );
				warningDialog.ShowDialog();
			}
			else
			{
				string result = worker.getResult();

//				if( alignmentView.SelectedIndex == 7 )
//				{
//					xmlBlastOutput.BlastOutput blastOutput = new xmlBlastOutput.BlastOutput();
//					xmlBlastOutput.WinBLASTXmlParser parser = 
//						new xmlBlastOutput.WinBLASTXmlParser( result, blastOutput );
//					parser.parse();
//					
//					XmlBlastOutputForm xmlOutput = new XmlBlastOutputForm( blastOutput );
//					xmlOutput.ShowDialog();
//				}
//				else 
				if( htmlCheckBox.Checked )
				{
					// HTML output: will write out to the TEMP directory, 
					// then show it in a Web browser
					string tempDir = Environment.GetEnvironmentVariable( "TEMP" );
					if( ! tempDir.EndsWith( "\\" ) )
						tempDir += "\\";
					
					int randomFileName = sm_random.Next();
					string tempFile = tempDir + randomFileName + ".html";
					writeOutToHtmlFile( tempFile, result );
					System.Diagnostics.Process.Start( tempFile );
				}
				else
				{
					BLASTResults results = new BLASTResults();
					results.blastResult.Text = result;

					// needed to unselect all of the text, not sure why it automatically 
					// selects all of the text.
					results.blastResult.Select( 0, 0 );
					results.ShowDialog();
				}
			}
		}

		private void writeOutToHtmlFile( string fileName, string result )
		{
			FileStream fs = new FileStream( fileName, FileMode.Create );
			ASCIIEncoding encoding = new ASCIIEncoding();
			byte[] output = encoding.GetBytes( result );
			fs.Write( output, 0, output.Length );
			fs.Flush();
			fs.Close();
		}

		// open file dialog methods for two separate buttons
		private void fileDialogButton_Click(object sender, System.EventArgs e)
		{
			DialogResult result = getDatabase().ShowDialog();

			if( result == DialogResult.OK )
				dbLocation.Text = getDatabase().getBlastDBName();
		}

		private void fileDialogButton1_Click(object sender, System.EventArgs e)
		{
			queryFileBtn.Checked = true;
			string queryLoc = getFileNameFromOpenFileDialog();
			queryLocation.Text = queryLoc;		
		}

		// helper method to return the name of the "opened" file from the dialog
		private string getFileNameFromOpenFileDialog()
		{
			DialogResult result = openFileDialog1.ShowDialog();
			if( result == DialogResult.Cancel )
				return "";

			return openFileDialog1.FileName;			
		}

		// instantiate and show About dialog box
		private void aboutButton_Click(object sender, System.EventArgs e)
		{
			About aboutDialog = new About();
			aboutDialog.ShowDialog();
		}

		private void closeButton_Click(object sender, System.EventArgs e)
		{
			// closes this form
			Close();
		}

		internal Databases getDatabase()
		{
			if( m_databasesForm == null )
				m_databasesForm = new Databases( loadDataSetFromFile() );

			return m_databasesForm;
		}

		private void WinBLAST_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if( m_databasesForm != null )
				saveDataSetToFile( m_databasesForm.getDataSet() );
		}

		private void inputSequence_TextChanged(object sender, System.EventArgs e)
		{
			inputSeqBtn.Checked = true;
		}

		private void inputSequence_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			inputSeqBtn.Checked = true;
		}

		private void queryLocation_TextChanged(object sender, System.EventArgs e)
		{
			queryFileBtn.Checked = true;
		}

		private void queryLocation_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			queryFileBtn.Checked = true;
		}
	}
}
