#!/usr/bin/perl 
###################################################################################################
#GABA - Introduction to the yapp program, pulling PWMs direct from PELLib.pm
###################################################################################################
use strict;
use CGI;
use PWMLib;

use Conf;
my $cfg=Conf->new();

my $cgi = CGI->new;

&showhtml;

print $cgi->end_html . "\n";
exit(0);

###################################################################################################
sub showhtml {
###################################################################################################

	print $cgi->header . "\n";

	print $cgi->start_html( 
		-title => " YAPP Eukaryotic Core Promoter Predictor",
		-style =>{-src=> "$cfg->{assetdir}/gaba.css"}
	);

	#print "<p align=left><a href=\'./index.html'><img src='gabalogo.png'></a></p>";
	print "<p><em><span style=\"font-family:'Comic Sans MS'; font-size:36.0pt; color:#339966; \">YAPP</span></em>";
	print "<span style=\"font-family:'Comic Sans MS'; font-size:10.0pt; color:#339966; \">Eukaryotic Core Promoter Predictor</span></p>"; 

	open (HT, "yapp_intro.html");
	while (<HT>) {
		print;
	}

	print $cgi->hr;
	print  $cgi->h3("List of PWMs for core promoter elements used by YAPP");

	my $pwmlib = PWMLib->new(); # motif PWM library and methods
	my $pwmref = $pwmlib->getlib();

	
	my ($m,$i,$j,$pwml);
    foreach $m (keys %{$pwmref}) {

		$pwml=$#{ $$pwmref{$m}[0] };    # pwm len
		print "<p><table border=1> <caption>$m</caption>\n";
		print "<tr><td>Pos</td><td>A</td><td>C</td><td>G</td><td>T</td></tr>\n";

        for ($i=0;$i<=$pwml;$i++) { #loop thro pwm
			print "<tr>" . "<td>" . ($i+1) . "</td>";
            for ($j=0;$j<4;$j++) {
				print "<td>" .  $$pwmref{$m} [$j] [$i] . "</td>";
            }
			print "</tr>\n";
		}
		print "</table></p>";
	}

}

