
//~--- JDK imports ------------------------------------------------------------

/* this class is the table model for the
        datasetTable
*/
import java.awt.*;
import java.awt.event.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;
import javax.swing.table.*;

//~--- classes ----------------------------------------------------------------

//it is implement AbstractTableModel, so it needs to implement all the methods

/**
 * Class for DataSet Table Model
 * @author Yue Lu
 * @version 1.2
 * @design Dr.George Fox, Yue Lu
 */
public class DataSetTableModel extends AbstractTableModel {
    public static final long serialVersionUID = 24362462L;

    //~--- fields -------------------------------------------------------------

    private Object[][]        Data;
    private int               rowNum;
    private ResultSetMetaData rsmd;

    //~--- constructors -------------------------------------------------------

    // constructor

    /**
     * returns the DataSet
     * @param rs ResultSet
     */
    public DataSetTableModel(final ResultSet rs) {
        try {
            rsmd = rs.getMetaData();

            int columns = getColumnCount();

            // make the two dimension array to put the query data
            Data = new Object[10][columns + 1];

            int i = 0;

            while (rs.next()) {
                for (int j = 1; j <= columns; j++) {
                    Data[i][j - 1] = rs.getObject(j);
                }

                i++;
            }

            rowNum = i;
        } catch (SQLException e) {
            System.out.println(
                "Error in connecting to Database\n Class: DataSetTableModel \n"
                + e);
        }
    }
    // get the values from each row and column

    //~--- get methods --------------------------------------------------------

    // get the column count

    /**
     * returns number of columns
     * @return returns Number of Columns
     */
    public int getColumnCount() {
        try {
            return rsmd.getColumnCount();
        } catch (SQLException e) {
            System.out.println(
                "Error in obtaining Column Count\n Class: DataSetTableModel \n"
                + e);

            return 0;
        }
    }

    // get the column name

    /**
     * returns Column Name
     * @param column column name that is to be retreived
     * @return name of column
     */
    public String getColumnName(final int column) {
        try {
            return rsmd.getColumnName(column + 1);
        } catch (SQLException e) {
            System.out.println(
                "Error in obtaining Column Name\n Class: DataSetTableModel \n"
                + e);

            return "";
        }
    }

    // get the row count

    /**
     * returns number of rows
     * @return returns number of rows in database
     */
    public int getRowCount() {
        return rowNum;
    }

    /**
     * returns value corresponding to particular column for a certain row
     * @param row Row number
     * @param column Column Name which is to be retreived
     * @return returns Value at specified row and column
     */
    public Object getValueAt(final int row, final int column) {
        if (row < rowNum) {
            return Data[row][column];
        } else {
            return null;
        }
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
