
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

import java.io.*;

/* This singleton class will get the instance of the database
        connection
*/
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

//~--- classes ----------------------------------------------------------------

/* get connection with database through the properties file*/

/**
 * Class for connecting to Database
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design George Fox, Yue Lu, Lalitha Viswanath
 */
public class DatabaseConnection {
    private static DatabaseConnection instance = null;

    //~--- fields -------------------------------------------------------------

    private Connection con;

    //~--- constructors -------------------------------------------------------

    // get the connection through the properties file

    /**
     * Constructor
     * @throws SQLException Throws SQL Exception corresponding to errors that might occur while
     * connecting to Database
     * @throws IOException Throws IOException corresponding to when errors occur
     * due to IO
     */
    protected DatabaseConnection() throws SQLException, IOException {
        //Properties      properties = new Properties();
        //String          fileName   = "C:/VDApp/Database_Manager.properties";
        //FileInputStream in         = new FileInputStream(fileName);

        //properties.load(in);

        // to get the driver, url, username, and password from the file
        //String drivers = properties.getProperty("jdbc.drivers");

        //if (drivers != null) {
         //   System.setProperty("jdbc.drivers", drivers);
        //}

       // String url      = properties.getProperty("jdbc.url");
       // String username = properties.getProperty("jdbc.username");
       // String password = properties.getProperty("jdbc.password");
// REGISTER DRIVER
    	
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");            
            //con = DriverManager.getConnection(url, "PUBLIC", "PUBLIC");
           // con=DriverManager.getConnection("jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=C:/VDApp.mdb;", "PUBLIC", "PUBLIC");
           con = DriverManager.getConnection("jdbc:odbc:VDApp", "PUBLIC", "PUBLIC");
           Statement s = con.createStatement();
        } catch (Exception e) {
           System.out.println("Failed to load JDBC/ODBC driver.");
           e.printStackTrace();
           e.getMessage();
        }

        //con = DriverManager.getConnection(url, username, password);
    }

    //~--- methods ------------------------------------------------------------

    // close the database

    /**
     * closes database connection
     */
    public void Close_Database() {
        try {
            con.close();
        } catch (SQLException ex) {
            System.out.println("" + ex);
        }
    }

    //~--- get methods --------------------------------------------------------

    // return the database connection

    /**
     * returns Database Connection
     * @return returns Database Connection
     */
    public Connection getConnection() {
        return con;
    }

    // get the instance of the database connection

    /**
     * returns connection to Database
     * @return returns instance of Database Connection
     */
    public static DatabaseConnection getInstance() {
        try {
            if (instance == null) {
                instance = new DatabaseConnection();
            }
        } catch (SQLException ex) {
            System.out.println(
                "This error is happening here Error in DatabaseConnection \nClass: Database Connection\n"
                + ex);
        } catch (IOException ex) {
            System.out.println(
                "Error in DatabaseConnection \nClass: Database Connection\n "
                + ex);
        }

        return instance;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
