
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;

import java.io.*;

/* this class get database connection instance and
        get the resultset
*/
import java.net.*;

import java.sql.*;

import java.util.*;

import javax.swing.*;

//~--- classes ----------------------------------------------------------------

/**
 * Class for retreiving result set corresponding to entire table, from database
 * @author Yue Lu, Lalitha Viswanath
 * @version 1.2
 * @design Dr.George Fox, Yue Lu, Lalitha Viswanath
 */
public class DatabaseResultSet {
    private ResultSet  Query_Result;
    private Connection con;
    private String     query;

    //~--- constructors -------------------------------------------------------

    /**
     * Constructor
     * @param q Query String
     */
    public DatabaseResultSet(String q) {
        query = q;

        try {
            // get the database connection instance
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();

            // execute the query
            Statement stmt = con.createStatement();
            ResultSet rs   = stmt.executeQuery(query);

            stmt.close();
            // rs.close();
        } catch (SQLException ex) {
            System.out.println(
                "Error in retreiving data from Database\nClass: DatabaseResultSet\n"
                + ex);
        }
    }

    //~--- get methods --------------------------------------------------------

    /**
     * Returns the result set
     * @return returns result set
     */
    public ResultSet getQueryResult() {
        return Query_Result;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
