
//~--- JDK imports ------------------------------------------------------------

import java.awt.*;

/*
 * SubMenu.java
 *
 * Created on July 13, 2004, 3:13 PM
 */

/**
 *
 * @author  Lalitha Viswanath
 */
import java.awt.event.*;

import java.io.*;

import java.net.*;

import java.sql.*;

import java.util.*;
import java.util.Dictionary;

import javax.swing.*;

//~--- classes ----------------------------------------------------------------

/**
 * Class for generating pop up menu on right click
 * @author Lalitha Viswanath
 * @version 1.1
 * @design Dr. George Fox, Lalitha Viswanath
 */
public class SubMenu extends JFrame {

    /**
     * number of zoomable child windows currently open
     */
    public static int numberOfZooms = 0;
    // assuming that not more than 500 zoom windows would be open for a window

    /**
     * array of child windows
     */
    public static JFrame[]   listChilds       = new JFrame[500];
    public static final long serialVersionUID = 24362462L;

    //~--- fields -------------------------------------------------------------

    private String     nonWhiteAttributeNames         = "",
                       preGenenonWhiteAttributeNames  = "",
                       postGenenonWhiteAttributeNames = "";
    private FileDialog fd                             = new FileDialog(this,
                                                            "Save File As", 1);
    private String     OtherRecordsQueryString        = "";
    private Vector<Object>     FinalDataToWrite               = new Vector<Object>(5, 2);
    private String     Table_Name;
    private Vector     colordata, pregcolordata, posgcolordata;
    private Connection con;
    private int        currentRecord, totalGenes;
    private int[]      directions;
    private int        disabledFlag, preGenedisabledFlag, postGenedisabledFlag;
    private JFrame     jfrme;
    private Component  jif;
    private JMenuItem  menuItem1, menuItem2, menuItem3, menuItem4, menuItem5;
    private JPopupMenu popup;
    private String     queryString;
    private String[]   uniqueAttrnw, uniqueAttrpreGnw, uniqueAttrpostGnw;
    private int gridFSubMenu;
    //~--- constructors -------------------------------------------------------

    /**
     * Creates a new instance of SubMenu
     * @param currentrecord current record on which user clicked right click
     * @param TableName Table whose data is being visualised
     * @param disflag flag to determine whether options in right click are to be  enabled or disabled
     * @param pregdisflag flag to determine whether options in right click are to be  enabled or disabled
     * @param postgdisflag flag to determine whether options in right click are to be  enabled or disabled
     * @param nwan Non White Attribute Names
     * @param pgnwan Non White Attribute Names for upstream region of gene
     * @param nwanpg Non White Attribute Names for downstream region of gene
     * @param totalg Total Number of genes to be displayed
     * @param dirns Array containing directions correspoding to each gene
     * @param cdata Vector containing colored attributes for gene region
     * @param pgcdata Vector containing colored attributes and shapes for upstream of gene region
     * @param cdatapg Vector containing colored attributes and shapes for downstream of gene region
     * @param uniquenw String of unique non-white attribute names corresponding to gene region
     * @param uniquepgnw String of unique non-white attribute names corresponding to upstream of gene region
     * @param uniquepostgnw String of unique non-white attribute names corresponding to downstream of gene region
     */
    public SubMenu(final int currentrecord, final String TableName,
                   final int disflag, final int pregdisflag,
                   final int postgdisflag, final String nwan,
                   final String pgnwan, final String nwanpg, final int totalg,
                   final int[] dirns, final Vector cdata,
                   final Vector pgcdata, final Vector cdatapg,
                   final String[] uniquenw, final String[] uniquepgnw,
                   final String[] uniquepostgnw, int gridFlag) {
        currentRecord                  = currentrecord;
        totalGenes                     = totalg;
        Table_Name                     = TableName.trim();
        uniqueAttrnw                   = new String[uniquenw.length];
        uniqueAttrnw                   = uniquenw;
        uniqueAttrpreGnw               = new String[uniquepgnw.length];
        uniqueAttrpreGnw               = uniquepgnw;
        uniqueAttrpostGnw              = new String[uniquepostgnw.length];
        uniqueAttrpostGnw              = uniquepostgnw;
        directions                     = new int[totalGenes];
        directions                     = dirns;
        colordata                      = new Vector(cdata.size());
        colordata                      = cdata;
        pregcolordata                  = new Vector(pgcdata.size());
        pregcolordata                  = pgcdata;
        posgcolordata                  = new Vector(cdatapg.size());
        posgcolordata                  = cdatapg;
        disabledFlag                   = disflag;
        preGenedisabledFlag            = pregdisflag;
        postGenedisabledFlag           = postgdisflag;
        nonWhiteAttributeNames         = nwan;
        preGenenonWhiteAttributeNames  = pgnwan;
        postGenenonWhiteAttributeNames = nwanpg;
        popup                          = new JPopupMenu();
        gridFSubMenu                   = gridFlag;
        menuItem3                      =
            new JMenuItem("Write gene or protein data to file ");

        popup.add(menuItem3);

        menuItem4 = new JMenuItem("Zoom In ");

        popup.add(menuItem4);

        if (currentRecord < 1) {
            menuItem4.setEnabled(false);
        }

        menuItem4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent a) {
                jif = new ZoomGenes(currentRecord, totalGenes, directions,
                                    colordata, pregcolordata, posgcolordata,
                                    Table_Name, gridFSubMenu);

                jif.setName("Zoom" + (numberOfZooms + 1));
                jif.setVisible(true);

                JFrame    jifFrame = new JFrame();
                Dimension d        =
                    Toolkit.getDefaultToolkit().getScreenSize();

                jifFrame.setSize(new Dimension(d.width / 2, d.height / 2));
                jifFrame.setTitle("Zoom Window " + (numberOfZooms + 1)
                                  + " for data in " + Table_Name);

                listChilds[numberOfZooms] = jifFrame;

                numberOfZooms++;

                jifFrame.setVisible(true);
                jifFrame.setVisible(true);
                jifFrame.getContentPane().add(jif);
            }
        });
        // dont add as attribute if only one row is present

        if (disabledFlag == 1) {
            //
            // System.out.println("Disabled Flag is set to true");
            popup.setEnabled(false);
            menuItem3.setEnabled(false);
        }

        menuItem3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent m) {
                fd.setDirectory("C:\\VDApp");
                fd.setVisible(true);

                String FileNameToWrite = null,
                       directory       = null;

                FileNameToWrite = fd.getFile();
                directory       = fd.getDirectory();

                if (FileNameToWrite != null) {
                    fd.setDirectory(directory);
                    // System.out.println("Let this work 3");
                    performSearchForOtherRecords(nonWhiteAttributeNames,
                                                 uniqueAttrnw);
                    writeRecordsToFile(FileNameToWrite, directory);
                }
            }
        });

        menuItem4 = new JMenuItem("Write upstream information to file ");

        popup.add(menuItem4);
        menuItem4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent m) {
                fd.setDirectory("C:\\VDApp");
                fd.setVisible(true);

                String FileNameToWrite = null,
                       directory       = null;

                FileNameToWrite = fd.getFile();
                directory       = fd.getDirectory();

                if (FileNameToWrite != null) {
                    fd.setDirectory(directory);
                    performSearchForOtherRecords(
                        preGenenonWhiteAttributeNames, uniqueAttrpreGnw);
                    writeRecordsToFile(FileNameToWrite, directory);
                }
            }
        });

        if (preGenedisabledFlag == 1) {
            menuItem4.setEnabled(false);
        }

        menuItem5 = new JMenuItem("Write downstream information to file ");

        popup.add(menuItem5);
        menuItem5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent m) {
                fd.setDirectory("C:\\VDApp");
                fd.setVisible(true);

                String FileNameToWrite = null,
                       directory       = null;

                FileNameToWrite = fd.getFile();
                directory       = fd.getDirectory();

                if (FileNameToWrite != null) {
                    fd.setDirectory(directory);
                    performSearchForOtherRecords(
                        postGenenonWhiteAttributeNames, uniqueAttrpostGnw);
                    writeRecordsToFile(FileNameToWrite, directory);
                }
            }
        });

        if (postGenedisabledFlag == 1) {
            menuItem5.setEnabled(false);
        }

        this.validate();
        this.validateTree();
    }

    //~--- methods ------------------------------------------------------------

    private void performSearchForOtherRecords(final String s,
            final String[] p) {
        queryString = "select " + s + "from  [" + Table_Name + "]  where ID="
                      + currentRecord + "";
        OtherRecordsQueryString = "";

        // System.out.println(" The query string is " + queryString);
        try {
            DatabaseConnection connection = DatabaseConnection.getInstance();

            con = connection.getConnection();

            if (queryString != null) {
                Statement stmt = con.createStatement();
                ResultSet rs   = stmt.executeQuery(queryString);

                rs = stmt.getResultSet();

                ResultSetMetaData rsmd1 = rs.getMetaData();

                rs.next();

                for (int i = 0; i < p.length; i++) {
                    String tmp   = p[i];
                    String value = new String();

                    if (tmp != null) {
                        value = rs.getString(tmp);

                        if (OtherRecordsQueryString.length() != 0) {
                            OtherRecordsQueryString += " AND ";
                        }

                        // nonWhiteVals[i]=value;
                        // System.out.println(" Value's length is "+ value.length()+" last char is "+ value.charAt(0));
                        if (rs.wasNull()) {
                            OtherRecordsQueryString += " (( " + Table_Name
                                                       + ".[" + tmp
                                                       + "]) Is Null) ";
                        } else {
                            OtherRecordsQueryString += " [" + tmp + "] = '"
                                                       + value + "'";
                        }

                        tmp = "";
                    }
                }

                String tableQuery = "Select * from [" + Table_Name
                                    + "] where (" + OtherRecordsQueryString
                                    + ")";

                con  = connection.getConnection();
                stmt = con.createStatement();
                rs   = stmt.executeQuery(tableQuery);

                ResultSetMetaData rsmd         = rs.getMetaData();
                int               NumberofCols = rsmd.getColumnCount();

                FinalDataToWrite.clear();

                while (rs.next()) {
                    String row = "";

                    for (int i = 1; i <= NumberofCols; i++) {
                        row += rs.getString(i) + "    ";
                    }

                    FinalDataToWrite.add(row);
                }

                stmt.close();
                // con.close();
            }
        } catch (SQLException se) {
            System.out.println("Error in retreiving records\nClass:SubMenu\n "
                               + se.toString());
        }
    }

    private void writeRecordsToFile(final String FileNameToWrite,
                                    final String directory) {
        try {
            File f = new File(directory, FileNameToWrite);

            System.out.println("Checking whether the file exists?\n"
                               + f.getAbsolutePath() + " "
                               + f.getAbsoluteFile());

            FileWriter     fw  = new FileWriter(f, false);
            BufferedWriter out = new BufferedWriter(fw);
            Iterator       i   = FinalDataToWrite.iterator();

            while (i.hasNext()) {
                out.write(i.next().toString());
                out.newLine();
            }

            out.close();
        } catch (IOException fio) {
            System.out.println("Error Trapping IO Exception\nClass:SubMenu\n"
                               + fio.toString());
        }
    }

    //~--- get methods --------------------------------------------------------

    /**
     * returns the Pop Up Menu
     * @return returns the popup menu
     */
    public JPopupMenu getPopUpMenu() {
        return popup;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
