#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include "main.h"


/* end of the program */
gint koniec(GtkWidget *kontrolka, gpointer dane) {
	opt_s *o ;

	o = (opt_s *) dane ;

	if(debug) ;

	/* check if output changed and ask for saving if yes */
	if(! o->output.changed || demand("Output not saved.\nReally quit?")) {
		printf("Koniec\n") ;
		gtk_main_quit() ;
		return(FALSE) ;
	} else {
		printf("Excellent!\n") ;
		return(TRUE) ;
	}
}


/* end of the program: translate functions */
void zakoncz(gpointer dane, guint signal, GtkWidget *kontrolka) {
	koniec(kontrolka, dane) ;
}

/* end of a gtk_main_quit dialog */
void zakoncz_dialog(GtkWidget *kontrolka, gpointer dane) {
	GtkWidget *okno ;

	okno = (GtkWidget *) dane ;
	gtk_widget_destroy(okno) ;
	gtk_main_quit() ;
}


/* shows the menu that was pressed. debugging purposes only */
void pokaz(gpointer dane, guint signal, GtkWidget *kontrolka) {
	char tmp[100] ;
	opt_s *o ;
	o = (opt_s*) dane ;
	sprintf(tmp, "Fabryka: %s is %d, dane %s",
		gtk_item_factory_path_from_widget(kontrolka), 
		signal, o->dupa) ;
	komunikat(tmp) ;
}


/* clears the selected window */
void clear_window(gpointer dane, guint signal, GtkWidget *kontrolka) {
	opt_s *o ;
	GtkWidget *tmp ;
	okno_s *okno ;
	GtkRequisition req = { -1 , 0 } ;

	o = (opt_s *) dane ;

	/* which window to choose */
	switch(signal){
		case 0: 
			okno = &o->input ;
			break ;
		case 1: 
			okno = &o->output ;
			break ;
		case 2: 
			okno = &o->error ;
			break ;
		default:
			break ;
	}

	gtk_editable_delete_text(GTK_EDITABLE(okno->tekst), 0, -1) ;
	okno->changed = FALSE ;


}

/* switches window showing on and off */
void toggle_windows(gpointer dane, guint signal, GtkWidget *kontrolka) {
	opt_s *o ;
	GtkWidget *tmp ;
	okno_s *okno ;
	GtkRequisition req = { -1 , 0 } ;

	o = (opt_s *) dane ;

	/* which window to choose */
	switch(signal){
		case 0: 
			okno = &o->input ;
			break ;
		case 1: 
			okno = &o->output ;
			break ;
		case 2: 
			okno = &o->error ;
			break ;
		default:
			break ;
	}

	if(okno->on) {
		gtk_widget_hide(okno->ramka) ;
		gtk_widget_size_request(okno->ramka, &req) ;
		okno->on = FALSE ;
	} else {
		gtk_widget_show(okno->ramka) ;
		okno->on = TRUE ;
	}
	gtk_paned_set_position(GTK_PANED(okno->parent), -1) ;
}


/* toggles the input window editable / not editable */
void toggle_editable(gpointer dane, guint signal, GtkWidget *kontrolka) {
	opt_s *o ;

	o = (opt_s *) dane ;
	o->editable = (!o->editable) ;
	gtk_text_set_editable(GTK_TEXT(o->input.tekst), o->editable) ;
}


/* toggles the input window editable / not editable */
void toggle_tooltips(gpointer dane, guint signal, GtkWidget *kontrolka) {
	opt_s *o ;

	o = (opt_s *) dane ;
	o->show_tooltips = (!o->show_tooltips) ;
	if(o->show_tooltips) gtk_tooltips_enable(o->tips) ;
	else gtk_tooltips_disable(o->tips) ;
}


/* sets the selected font; dialog window is passed in the o->tmp structure */
void set_font(GtkWidget *okno, opt_s *o) {
	char *czcionka ;
	GtkWidget *wybcz ;
	GtkFontSelectionDialog *wybcz_d ;

	wybcz_d = (GtkFontSelectionDialog *) o->tmp ;
	wybcz = (GtkWidget *) o->tmp ;
	czcionka = gtk_font_selection_dialog_get_font_name(wybcz_d) ;

	if(czcionka != NULL) {
		printf("czcionka %s\n", czcionka) ;
		o->czcionka = gdk_font_load(czcionka) ;
	} else {
		printf("null font loaded \n") ;
	}

	gtk_widget_destroy(wybcz) ;
}


/* select font dialog */
void select_font(opt_s *o) {

	GtkWidget *wybcz ;
	GtkFontSelectionDialog *wybcz_d ;

	wybcz = gtk_font_selection_dialog_new("Choose a font for the main window") ;
	wybcz_d = GTK_FONT_SELECTION_DIALOG(wybcz) ;

	o->tmp = wybcz ;

	gtk_signal_connect(GTK_OBJECT(wybcz_d->ok_button),
		"clicked", GTK_SIGNAL_FUNC(set_font), o) ;
	gtk_signal_connect(GTK_OBJECT(wybcz_d->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(close_dialog), GTK_OBJECT(wybcz_d)) ;
	gtk_signal_connect(GTK_OBJECT(wybcz_d), "destroy", 
		GTK_SIGNAL_FUNC(zakoncz_dialog), wybcz_d) ;
	gtk_widget_show(wybcz) ;

	gtk_main() ;

}


/* sets new style recursively for a widget and all further winoows */
void set_style_recursive(GtkWidget *okno, gpointer dane) {
	GtkStyle *styl ;

	styl = (GtkStyle *) dane ;
	gtk_widget_set_style(okno, styl) ;
	if(GTK_IS_CONTAINER(okno)) {
		gtk_container_foreach(GTK_CONTAINER(okno), set_style_recursive, styl) ;
	}

}


/* redraws text in a text window using the new font set */
void redraw_text(opt_s *o) {
	gchar *tmp ;
	tmp = gtk_editable_get_chars(GTK_EDITABLE(o->input.tekst), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(o->input.tekst), 0, -1);
	gtk_text_insert(GTK_TEXT(o->input.tekst), o->czcionka, NULL, NULL,
		tmp, strlen(tmp)) ;
}


/* changes fonts */
void change_font(opt_s *o) {
	GtkStyle *styl, *styl_default ;
	select_font(o) ;
	redraw_text(o) ;
}


/* given a filename and it's position, it appends the apriopriate entry to the
 * "File" menu */
int append_single_entry(opt_s *o, char *filen, int i) {
	GtkItemFactoryEntry separator = {"/File/sep2",	NULL,	NULL,	0, "<Separator>"} ;
	GtkItemFactoryEntry element = {NULL, NULL,	file_open_from_list,	0} ;
	char *menun, *a, *b, tmp1[10], tmp2[10] ;

	if(! (filen)) return ;

	if(i == 0) gtk_item_factory_create_items(o->fabryka, 1, &separator, o) ;
	if(i == -1) i = g_list_length(o->file_history) - 1 ;

	if(! (menun = strrchr(filen, '/')) ) menun = filen ;
	else menun++ ;

	a = malloc(strlen(menun) + 30) ;
	sprintf(a, "/File/_%i %s", i+1, menun) ;
	sprintf(tmp1, "<control>%i", i+1) ;
	element.path = a ;
	element.accelerator = tmp1 ;
	element.callback_action = i ;

	gtk_item_factory_create_items(o->fabryka, 1, &element, o) ;
	free(a) ;

	return EXIT_SUCCESS ;
}


/* appends the file entries from config file */ 
int append_entries(opt_s *o) {
	char *filen, *menun, *a, *b, tmp1[10], tmp2[10] ;
	int i ;

	if(o->file_history == NULL) return ;

	for(i = 0 ; i < g_list_length(o->file_history) ; i++ ) {

		filen = g_list_nth_data(o->file_history, i) ;
		append_single_entry(o, filen, i) ;

	}

	return EXIT_SUCCESS ;
}


/* here, the main menu and main window is created */
void inicjuj_menu(opt_s *o) {
	
	int nel ;

	static GtkItemFactoryEntry elementy[] = {
		{"/_File",	NULL, 0, 0, "<Branch>"},
		{"/File/tearoff1",	NULL,	NULL, 0, "<Tearoff>"},
		{"/File/_New",	"<control>N",	NULL,	0},
		{"/File/_Open input file", "<control>O",	file_open,	0},
		{"/File/_Save output", "<control>S",	file_save,	1},
		{"/File/S_ave output as", "<control>A",	file_save_as,	1},
		{"/File/sep1",	NULL,	NULL,	0, "<Separator>"},
		{"/File/_Quit",	"<control>Q",	zakoncz,	0},

		{"/_Edit",	NULL, 0, 0, "<Branch>"},
		{"/Edit/tearoff1",	NULL,	NULL, 0, "<Tearoff>"},
		{"/Edit/Clear _output",	"<control>C",	clear_window,	1},

		{"/_Options", NULL,	0,	0, "<Branch>"},
		{"/Options/tearoff1",	NULL,	0, 0, "<Tearoff>"},
		{"/Options/_Editable",	NULL,	toggle_editable,	0, "<CheckItem>"},
		{"/Options/_Hide tooltips",	NULL,	toggle_tooltips,	0, "<CheckItem>"},
		{"/Options/_Font",	NULL,	change_font,	0},

		{"/_Tools", NULL,	0,	0, "<Branch>"},
		{"/Tools/tearoff1",	NULL,	NULL, 0, "<Tearoff>"},
		{"/Tools/_GC graph",	NULL,	graph_gc,	0},
		{"/Tools/Graph _3D", NULL, NULL, 0, "<Branch>"},
		{"/Tools/Graph 3D/_From input", NULL, graph3d_create_from_input, 0},
		{"/Tools/Graph 3D/_From file", NULL, graph3d_create_from_file, 0},
		{"/Tools/_Command...",	NULL,	command,	0},

		{"/_Programs", NULL,	0,	0, "<Branch>"},
		{"/Programs/tearoff1",	NULL,	NULL, 0, "<Tearoff>"},

		{"/_Windows", NULL,	0,	0, "<Branch>"},
		{"/Windows/tearoff1",	NULL,	0, 0, "<Tearoff>"},
		{"/Windows/_Input",	NULL,	toggle_windows,	0, "<CheckItem>"},
		{"/Windows/_Output",	NULL,	toggle_windows,	1, "<CheckItem>"},
		{"/Windows/_Error",	NULL,	toggle_windows,	2, "<CheckItem>"} } ,

	helps[] = {
		{"/_Help",	NULL, 0, 0, "<LastBranch>"},
		/* {"/Help/_Topics", NULL,	help_about,	0} ,*/
		{"/Help/_Readme", NULL,	help_text,	0} ,
		{"/Help/_License", NULL,	help_text,	1} ,
		{"/Help/_About",	NULL,	help_about,	0}
	} ;

	nel = sizeof(elementy) / sizeof(GtkItemFactoryEntry) ;
	o->shortcuts = gtk_accel_group_new() ;
	gtk_accel_group_attach(o->shortcuts, GTK_OBJECT(o->okno)) ;

	o->fabryka = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<bla>", o->shortcuts) ;
	gtk_item_factory_create_items(o->fabryka, nel, elementy, o) ;

	append_entries(o) ;
	append_programs(o) ;

	nel = sizeof(helps) / sizeof(GtkItemFactoryEntry) ;
	gtk_item_factory_create_items(o->fabryka, nel, helps, o) ;

	gtk_box_pack_start(GTK_BOX(o->ypole), 
		gtk_item_factory_get_widget(o->fabryka,"<bla>"), FALSE, FALSE, 0) ;
}


/* changes the "changed" flag in okno_s struct when text is modified */
void tekst_changed(GtkEditable *kontrolka, gpointer data) {
	okno_s *o ;
	o = (okno_s *) data ;
	o->changed = TRUE ;
}


/* function that handles inserting of the text */
void insert_text(GtkEditable *w, const gchar *text, gint l, gint *p, gpointer data) {

	gtk_signal_handler_block_by_func(GTK_OBJECT(w), GTK_SIGNAL_FUNC(insert_text), data) ;
	gtk_editable_insert_text(w, text, l, p) ;
	gtk_signal_handler_unblock_by_func(GTK_OBJECT(w), GTK_SIGNAL_FUNC(insert_text), data) ;
	gtk_signal_emit_stop_by_name(GTK_OBJECT(w), "insert_text") ;

}


/* initiates the color map */
int allocate_colors(opt_s *o) {
	int i, n = 8 ;

	o->ncolors = n ;
	o->colors = malloc(n * sizeof(*o->colors)) ;
	gdk_color_parse("black", &o->colors[0]) ;
	gdk_color_parse("red", &o->colors[1]) ; 
	gdk_color_parse("green", &o->colors[2]) ;
	gdk_color_parse("blue", &o->colors[3]) ;
	gdk_color_parse("violet", &o->colors[4]) ;
	gdk_color_parse("yellow", &o->colors[5]) ;
	gdk_color_parse("magenta", &o->colors[6]) ;
	gdk_color_parse("cyan", &o->colors[7]) ; 

	for(i = 0; i < n; i++) {

		if(!gdk_colormap_alloc_color(gdk_colormap_get_system(), &o->colors[i], FALSE, TRUE)) 
			printf("Color %i could not be allocated\n", i) ;

	}
	
}

/* makes a table containing a text widget with scroll bars and adds it to the
 * specified GtkWidget called kontrolka */
void make_ramka(GtkWidget *kontrolka, okno_s *o) {

	o->tekst = gtk_text_new(NULL, NULL) ;
	gtk_text_set_word_wrap(GTK_TEXT(o->tekst), FALSE) ;
	gtk_text_set_line_wrap(GTK_TEXT(o->tekst), FALSE) ;

	gtk_widget_show(o->tekst) ;
	gtk_text_set_editable(GTK_TEXT(o->tekst), FALSE) ;

	/* handlers for "change text" and "insert text" */
	gtk_signal_connect(GTK_OBJECT(o->tekst), "changed", 
		GTK_SIGNAL_FUNC(tekst_changed), o) ;
	gtk_signal_connect(GTK_OBJECT(o->tekst), "insert_text", 
		GTK_SIGNAL_FUNC(insert_text), o) ;

	o->tabela = gtk_scrolled_window_new(NULL, NULL) ;
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(o->tabela), 
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC) ;
	gtk_container_add(GTK_CONTAINER(o->tabela), o->tekst) ;
	gtk_widget_show(o->tabela) ;

	gtk_container_add(GTK_CONTAINER(kontrolka), o->tabela) ;

	o->on = TRUE ;
}


/* initiates the main window and calls the inicjuj_menu function */
void inicjuj_main_window(opt_s *o) {
	int i ;
	GtkWidget *xpasek, *ypasek, *panel1, *panel2 ;
	GtkTooltips *tips ;

	/* creating main window */
	o->okno = gtk_window_new(GTK_WINDOW_TOPLEVEL) ;
	gtk_widget_show(o->okno) ;
	gtk_widget_set_usize(o->okno,
		gdk_screen_width() * 0.8, gdk_screen_height() * 0.8) ;
	gtk_window_set_title(GTK_WINDOW(o->okno),"Arka") ;
	gtk_signal_connect(GTK_OBJECT(o->okno), "destroy", 
		GTK_SIGNAL_FUNC(koniec), o) ;

	/* vertical container */
	o->ypole = gtk_vbox_new(FALSE, 1) ;
	gtk_container_add(GTK_CONTAINER(o->okno), o->ypole) ;
	gtk_widget_show(o->ypole) ;

	inicjuj_menu(o) ;

	/* initiating three main windows */
	strcpy(o->input.title, "Input") ;
	strcpy(o->output.title, "Output") ;
	strcpy(o->error.title, "Errors") ;

	o->input.ramka = gtk_frame_new(o->input.title) ;
	o->output.ramka = gtk_frame_new(o->output.title) ;
	o->error.ramka = gtk_frame_new(o->error.title) ;

	make_ramka(o->input.ramka, &o->input) ;
	make_ramka(o->output.ramka, &o->output) ;
	make_ramka(o->error.ramka, &o->error) ;

	/* text windows are stored in panels so we can resize them */
	panel1 = gtk_vpaned_new() ;
	panel2 = gtk_vpaned_new() ;

	gtk_paned_pack1(GTK_PANED(panel2), o->input.ramka, TRUE, TRUE) ;
	gtk_paned_pack2(GTK_PANED(panel2), o->output.ramka, TRUE, TRUE) ;
	gtk_paned_pack1(GTK_PANED(panel1), panel2, TRUE, TRUE) ;
	gtk_paned_pack2(GTK_PANED(panel1), o->error.ramka, TRUE, TRUE) ;

	o->input.parent = panel2 ;
	o->output.parent = panel2 ;
	o->error.parent = panel1 ;
	
	gtk_box_pack_start(GTK_BOX(o->ypole), panel1, TRUE, TRUE, 0) ;

	gtk_tooltips_set_tip(GTK_TOOLTIPS(o->tips), o->input.tekst,
		"This is the data input window. " 
		"Use the FILE/Open menu entry to load data into that window", "Just try it") ;
	gtk_tooltips_set_tip(GTK_TOOLTIPS(o->tips), o->output.tekst,
		"This is the output window. "
		"The output of any external programs (from the PROGRAMS menu)"
		"you will run.", "Just try it") ;
	gtk_tooltips_set_tip(GTK_TOOLTIPS(o->tips), o->error.tekst,
		"This is the error window. "
		"You will find here any error messages issued by the programs run."
		"In other words, it corresponds to the stderr", "Just try it") ;


	/* status bar */
	o->status = gtk_statusbar_new () ;
	i = gtk_statusbar_get_context_id(GTK_STATUSBAR(o->status), "dupa") ;
	gtk_statusbar_push(GTK_STATUSBAR(o->status), i, "Welcome!") ;
	gtk_box_pack_start(GTK_BOX(o->ypole), o->status, FALSE, FALSE, 0) ;

	gtk_window_set_position(GTK_WINDOW(o->okno), GTK_WIN_POS_CENTER) ;
	gtk_widget_show_all(o->okno) ;
}

