/* main function and some of the most important tools */
#define MAIN_C

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include "main.h"
#include "genpak.h"



/* writes a text into a specified text window or, if window is not currently
 * displayed, into the apripriate buffer */
int write_text(char *text, okno_s *okno, opt_s *o) {
	gchar *tmp ;
	int a = 0, ln ;

	if(!text) return EXIT_FAILURE;

	gtk_text_insert(GTK_TEXT(okno->tekst), o->czcionka, NULL, NULL, text, -1) ;
	gtk_text_insert(GTK_TEXT(okno->tekst), o->czcionka, NULL, NULL, "\n", -1) ;
			
	return EXIT_SUCCESS ;
}


/* runs the command specified in the comline and adjusts output / input / error
 * windows */
int execute(char *comline, opt_s *o) {

	char *bufor ;
	int lzn, a ;
	FILE *fp ;

	if(!comline) return EXIT_FAILURE ;
	gdk_window_set_cursor(o->okno->window, o->cursor_wait) ;

	if(window_tofile(&o->input, o) || write_text(comline, &o->error, o)) {
		gdk_window_set_cursor(o->okno->window, o->cursor_normal) ;
		return EXIT_FAILURE ;
	}

	switch( (a = system(comline)) ) { 
		case 127:
			komunikat("/bin/sh is missing (how can it be?)") ;
			gdk_window_set_cursor(o->okno->window, o->cursor_normal) ;
			return EXIT_FAILURE ;
			break ;
		case 0:
			break ;
		default:
			komunikat("There was an error executing your command.\n"
				"system() returned %i", a) ;
			write_text("Error during execution\n", &o->error, o) ;
			gdk_window_set_cursor(o->okno->window, o->cursor_normal) ;
			break ;
	}

	if( (fp = fopen(o->error.tmpfil, "r")) == NULL) {
		komunikat("Cannot open temporary error file for reading.\n"
		"This probably means serious problems with this program") ;
		gdk_window_set_cursor(o->okno->window, o->cursor_normal) ;
		return EXIT_FAILURE;
	}

	read_file(fp, o, &o->error) ;
	fclose(fp) ;

	if( (fp = fopen(o->output.tmpfil, "r")) == NULL) {
		komunikat("Cannot open temporary output file for reading.\n"
		"This probably means serious problems with this program") ;
		gdk_window_set_cursor(o->okno->window, o->cursor_normal) ;
		return EXIT_FAILURE;
	}

	read_file(fp, o, &o->output) ;
	fclose(fp) ;
	gdk_window_set_cursor(o->okno->window, o->cursor_normal) ;
	return EXIT_SUCCESS ;
}


/* on pressing "OK" button, this function takes the string from an entry field */
void command_end_dialog(GtkWidget *okno, gpointer dane) {
	data_s *d ;

	/* cast the arguments into apriopriate types */
	d = (data_s *) dane ;

	/* read the string from the entry button and store it in the provided string */
	d->data = gtk_editable_get_chars(GTK_EDITABLE(d->window1), 0, -1) ;

	/* close the window */
	gtk_widget_destroy(d->window2) ;
	gtk_main_quit() ;

}


/* executes some command */
void command(gpointer dane, guint signal, GtkWidget *kontrolka) {
	char *polec, tmp[500], comline[500] ;
	data_s d ;	/* temporal storage needed for argument passing */
	opt_s *o ;	/* general program options */
	GtkWidget *label, *button, *ypole, *dialog, *entry ;

	o = (opt_s *) dane ;

	/* Creating dialog window */
	dialog = gtk_dialog_new() ;
	gtk_signal_connect(GTK_OBJECT(dialog), "destroy", 
		GTK_SIGNAL_FUNC(zakoncz_dialog), dialog) ;
	gtk_window_set_title(GTK_WINDOW(dialog), "Optional command") ;
	gtk_container_set_border_width(GTK_CONTAINER(dialog), 10) ;

	/* short description */
	label = gtk_label_new(
		"Please enter a command which should be executed using /bin/sh\n"
		"Use a `%s' as a substitute for a file containing the input window\n"
		"For example, to count the characters in the input window, type in: \n"
		"wc -c %s \n"
		"Do not use any other '%' characters.\n") ;
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT) ;
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label) ;
	gtk_widget_show(label) ;

	/* entry field */
	entry = gtk_combo_new() ;
	gtk_combo_set_popdown_strings(GTK_COMBO(entry), o->command_history) ;
	gtk_entry_set_max_length(GTK_ENTRY(GTK_COMBO(entry)->entry), 150) ;
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), entry) ;
	gtk_widget_show(entry) ;
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(entry)->entry), "activate",
		GTK_SIGNAL_FUNC(command_end_dialog), &d) ;

	/* this data is needed by the command_dialog_end function */
	d.data = NULL ;
	d.window1 = GTK_COMBO(entry)->entry ;
	d.window2 = dialog ;

	/* "OK" button */
	button = gtk_button_new_with_label("OK") ;
	gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		GTK_SIGNAL_FUNC(command_end_dialog), &d) ;
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT) ;
	gtk_widget_grab_default(button) ;
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area), button);
	gtk_widget_show(button) ;

	gtk_window_set_focus(GTK_WINDOW(dialog), GTK_COMBO(entry)->entry) ;
	gtk_widget_show(dialog) ;

	gtk_main() ;

	polec = (char*) d.data ;

	/* checking whether we left via window destroy or "OK" button */
	if(!polec) {
		printf("No command issued\n") ;
		return ;
	}

	/* filling in file parameters and executing the command */
	o->command_history = g_list_prepend(o->command_history, polec) ;

	if(strchr(polec, '%'))
		sprintf(tmp, polec, o->input.tmpfil) ;
	else strcpy(tmp, polec) ;

	strcat(tmp, " > %s 2> %s ") ;
	sprintf(comline, tmp, o->output.tmpfil, o->error.tmpfil) ; 
	execute(comline, o) ;
}



/*
 * 
 */
int main(int argc, char *argv[]) {

	GtkWidget *popup ;
	opt_s opt ;
	char tmp[FILENAME_MAX] ;

	gtk_init(&argc, &argv) ;

	popup = popup_at_start(&opt) ;


	opt.editable = FALSE ;
	opt.show_tooltips = TRUE ;
	opt.tips = gtk_tooltips_new() ;
	opt.czcionka = gdk_font_load("-*-courier-medium-r-*-*-*-*-*-*-*-*-*-*") ;
	if(!opt.czcionka) 
		opt.czcionka = (gtk_widget_get_default_style())->font ;

	opt.input.on = TRUE ;
	opt.output.on = TRUE ;
	opt.error.on = TRUE ;

	opt.input.changed = FALSE ;
	opt.output.changed = FALSE ;
	opt.error.changed = FALSE ;

	opt.command_history = NULL ;
	opt.command_history = g_list_append(opt.command_history, "ls -l %s") ;
	opt.command_history = g_list_append(opt.command_history, "wc -c %s") ;

	strncpy(tmp, getenv("PWD"), FILENAME_MAX) ;
	strcat(tmp, "/") ;
	opt.wdir = strdup(tmp) ;
	if(opt.wdir != NULL) printf("Working directory %s\n", opt.wdir) ;

	opt.file_history = NULL ;

	read_rcfile(&opt) ;

	/* we need temporary files for the gp programs to use */
	sprintf(opt.input.tmpfil,"/tmp/tescik-inputXXXXXX") ;
	sprintf(opt.output.tmpfil,"/tmp/tescik-outputXXXXXX") ;
	sprintf(opt.error.tmpfil,"/tmp/tescik-errorXXXXXX") ;

	if(mktemp(opt.input.tmpfil) == NULL ||
	  mktemp(opt.output.tmpfil) == NULL ||
	   mktemp(opt.error.tmpfil) == NULL) exit(1) ;

	/* each time a file is loaded, input gets erased; but error and output windows
	 * accumulate the produced data */
	opt.input.overwrite = TRUE ;
	opt.output.overwrite = FALSE ;
	opt.error.overwrite = FALSE ;

	opt.input.filenam = NULL ;
	opt.output.filenam = NULL ;
	opt.error.filenam = NULL ;

	inicjuj_main_window(&opt) ;
	//gtk_window_activate_focus(GTK_WINDOW(popup)) ;
	allocate_colors(&opt) ;

	opt.cursor_normal = gdk_cursor_new(GDK_ARROW) ;
	opt.cursor_wait = gdk_cursor_new(GDK_WATCH) ;
	gdk_window_set_cursor(opt.okno->window,opt.cursor_normal) ;

	gtk_main() ;

	remove(opt.input.tmpfil) ;
	remove(opt.output.tmpfil) ;
	remove(opt.error.tmpfil) ;

	write_rcfile(&opt) ;

	return EXIT_SUCCESS ;
}

