#define PROGRAM "arka"
#define VERSION "0.03"
#define ARKA_PROG_NUM_MAX 200

#ifndef ARKA_PROGRAMS
	#define ARKA_PROGRAMS "/etc/arkarc"
#endif


#ifndef ARKA_DIR
	#define ARKA_DIR "/.arka"
#endif

#ifndef ARKA_GLOBAL
	#define ARKA_GLOBAL "/etc/arkarc"
#endif


typedef enum {UNKNOWN=0, DNA, RNA, PROTEIN, WRONG } sequence_type ;

#ifdef MAIN_C
	int debug = 0 ;
#else
	extern int debug ;
#endif

struct sekw_ss {
	char name[200] ;
	char *sequ ;
	long leng ;
	struct sekw_ss *next ;
	sequence_type type ; } ;

typedef struct sekw_ss sekw ;

typedef struct {
	GtkWidget * window ;
	GtkWidget * window1 ;
	GtkWidget * window2 ;
	gpointer data ; 
	gpointer data1 ; 
	gpointer data2 ; 
	gpointer data3 ; 
	gpointer data4 ;
	gpointer data5 ; } data_s ;


typedef struct {
	char *progname ;
	char *optstr ;
	int nopts ;
	char *description ;
	char *optdesc[30] ; } programopt_s ;

/* structure containing a frame with a text widget and two scrollbars */
typedef struct {
	int on ;
	int changed ;
	int overwrite ;
	char file ;
	char *filenam ;
	char tmpfil[FILENAME_MAX] ;
	char title[100] ;
	gchar *contents ;
	GtkWidget *parent ;
	GtkWidget *ramka ;
	GtkWidget *tabela ;
	GtkWidget *tekst ;
	GtkWidget *tmp ; } okno_s ;
	
/* structure holding all data about the current state of things */
typedef struct {
	char file[FILENAME_MAX] ;
	char *wdir ;
	GtkWidget *okno ;
	GtkWidget *ypole ;
	GtkWidget *status ;
	GtkAccelGroup *shortcuts ;
	GtkItemFactory *fabryka ;
	GtkTooltips *tips ;

	okno_s sequence ;
	okno_s input ;
	okno_s output ;
	okno_s error ;

	GdkFont *czcionka ;
	GdkColor *colors ;
	int ncolors ;
	GdkCursor *cursor_normal ;
	GdkCursor *cursor_wait ;

	sekw *seqlist ;
	char default_command[600] ;
	GList *command_history  ;
	GList *file_history  ;

	int editable ;
	int show_tooltips ;

	GtkWidget *tmp ; 
	char dupa[100] ; } opt_s ;


/* interface.c */
void file_work(GtkWidget *k, gpointer dane) ;
void file_select(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void destroy_dialog(GtkWidget *okno, gpointer dane) ;
void close_dialog(GtkWidget *kontrolka, gpointer dane) ;
gint koniec(GtkWidget *kontrolka, gpointer gdane) ;
void zakoncz(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void zakoncz_dialog(GtkWidget *kontrolka, gpointer dane) ;
void pokaz(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void toggle_editable(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void set_font(GtkWidget *okno, opt_s *o) ;
void select_font(opt_s *o) ;
void change_font(opt_s *o) ;
void set_style_recursive(GtkWidget *okno, gpointer dane) ;
void redraw_text(opt_s *o) ;
void inicjuj_menu(opt_s *o) ;
void make_ramka(GtkWidget *kontrolka, okno_s *o) ;
void inicjuj_main_window(opt_s *o) ;
void toggle_windows(gpointer dane, guint signal, GtkWidget *kontrolka) ;
int append_single_entry(opt_s *o, char *filen, int i) ;

/* main.c */
void gc_content(gpointer dane, guint signal, GtkWidget *kontrolka) ;
int write_text(char *text, okno_s *okno, opt_s *o) ;
int execute(char *comline, opt_s *o) ;
void seq2prot(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void graph_gc(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void command(gpointer dane, guint signal, GtkWidget *kontrolka) ;

/* graph3d.c */
void graph3d_create_from_file(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void graph3d_create_from_input(gpointer dane, guint signal, GtkWidget *kontrolka) ;

/* file.c */
int read_file(FILE *fp, opt_s *o, okno_s *okno) ;
char *file_get_name(opt_s *o, char *default_name) ;
void file_select(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void save_file(GtkWidget *k, gpointer dane) ;
void open_file(GtkWidget *k, gpointer dane) ;
int window_tofile(okno_s *okno, opt_s *o) ;
void file_save_as(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void file_save(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void file_open(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void file_open_from_list(gpointer dane, guint signal, GtkWidget *kontrolka) ;

/* komunikat.c */
void komunikat(char *tekst, ...) ;
int demand(char *tekst, ...) ;

/* rcfile.c */
int read_rcfile(opt_s *o) ;
int write_rcfile(opt_s *o) ;

/* options.c */
char *my_strdup(char *string) ;
void program_select(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void append_programs(opt_s *o) ;
char* set_options(int wh, opt_s *o) ;

/* help.c */
void help_text(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void help_about(gpointer dane, guint signal, GtkWidget *kontrolka) ;
GtkWidget * popup_at_start(opt_s *o) ;
