/* here are all options for the gp programs, stored in a static variable called
 * programs, of type programopt_s. Functions in this source file deal with
 * preparing the menu entries and creating a suitable options window if one of
 * these entries is called. Then a commandline is passed to function "execute"
 * from main.c */


#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include "main.h"

/* here are the descriptions of the programs 

	typedef struct {
		char *progname ; (name of the program)
		char *optstr ;		(option string as accepted by getopt)
		int nopts ;			(number of options)
		char *description ; (description of what the program does)
		char *optdesc[30] ; } (descriptions of the options)
			programopt_s ;
 */

static programopt_s programs[] = {

	{ "gp_acc", "el:p:", 3,
		"Encode the sequence into a numerical series of numbers and "
		"computate their auto-cross correlation (ACC) coefficients",
		{"encode only, do not computate the ACC coefficients",
		 "print a header with the descriptions of variables as if computated"
		 " for a sequence of a length of the given value",
		 "computate crossterms up to this sequence position"}
	},

	{ "gp_cusage", "c:op:", 3,
		"Print the codon usage of a DNA / RNA sequence",
		{"Use an alternative codon table loaded from the given file",
		 "Only print the codon table, do not computate the codon usage",
		 "this option determines how the output should be formatted."
		 " use \"u\" or \"ugly\" for a simple two-column table, use \"n\" or"
		 " \"nice\" for a nicely formatted table" }
	},

	{ "gp_dimer", "l:", 1,
	 	"Print the frequency of nucleotide dimers in a DNA/ RNA sequence",
		{"If you give a value here, gp_dimer will calculate the frequencies"
		 " of dimeres with a space of <value> nucleotides between them"}
	},

	{ "gp_findorf", "m:M:o:c:p:", 5,
		"Find ORFs in a DNA / RNA nucleotide sequence",
		{"set the minimal ORF length (default -- 100 bp)",
		 "set the maximal ORF length (default -- unlimited)",
		 "if you input \"s\" here, the program will print out the protein sequences."
		 "If you type in an \"n\", the program will show the ORFs positions in the "
		 "examined sequence",
		 "load the optional codon table",
		 "instead of looking for ORFs in a sequence, just print the the codon table. "
		 "If the argument value is \"n\" or \"nice\", it will be a nicely formatted "
		 "table. If the value is \"u\" or \"ugly\", it will be a simple two-column "
		 "output."}
	},
		 

	{ "gp_gc", "tmD:p:", 4,
		"Determine the GC contents of a DNA / RNA sequence", 
		{"Compute the total GC % of all examined sequences",
		 "Compute the mean GC % of the examined sequences",
		 "For each sequence, print the GC % distribution \n"
		 "The given value specifies the window length\n"
		 "used to computate the local GC %.\n"
		 "(If empty, option will not be used)",
		 "just for run" } 
	},

	{ "gp_getseq", "l:", 1,
		"Read a list of positions from a file and convert them into corresponding "
		"DNA sequences",
		{"the file with the sequence positions"}
	},

	{ "gp_matrix", "Mm:G:gtT:NS", 8,
		"Search for promoters using a Hertz matrix",
		{"computate a new matrix and show it on the output",
		 "type in here the name of the file containing the Hertz matrix",
		 "adjust the matrix to the given GC contents",
		 "ignore gap penalties",
		 "assume that the transcription start is experimentally defined",
		 "print only the sequences with the score higher then <value>",
		 "show sequence names",
		 "do not show the sequences"}
	},

	{ "gp_mkmtx", "ag:l", 3,
		"Create a nucleotide frequency matrix",
		{"Instead of frequencies, computate the number of occurencies",
		 "divade each frequency by an expected frequency corresponding to a GC "
		 "contents of <value> percent",
		 "do not apply logarythmic scaling of sequences"}
	},

	{ "gp_pattern", "l:", 1,
		"Computate the frequencies of DNA / RNA patterns",
		{"the length of the calculated patterns. Note that the number of possible"
		 " patterns grows exponentially with this parameter"}
	},

	{ "gp_ransdeq", "l:n:", 2,
		"Generate random sequences based on the input sequence",
		{"set the length of the random sequence to this value",
		 "input here the number of the sequences to be generated"}
	},

	{ "gp_tm", "tsM:c:mN", 6,
		"Calculate the melting temperature of the sequences",
		{"use the 4*GC+2*AT thumb rule to calculate the Tm",
		 "use symmetry correction for selfcomplementary sequences",
		 "set the nucleic acid concentration to <value> mM",
		 "set the salt concentration to <value> M",
		 "calculate only the mean Tm for all queried sequences",
		 "show sequence names"}
	},

	{ "gp_trimer", "", 0,
		"Calculate the frequencies of nucleotide trimers",
		{}
	},


	{ "gp_seq2prot", "c:lp:", 3,
		"Converts a DNA / RNA sequence into a protein sequence",
		{"Read the optional codon usage table from a file",
		 "Be liberal about stop / start codons (that is, \n"
		 "translate the sequence even if stop/ start codon is missing)",
		 "print a codon table & exit; argument can be 'nice' or 'ugly'"} 
	}

} ;


/* catches the signal from menu and executes the program */
void program_select(gpointer dane, guint signal, GtkWidget *kontrolka) {
	opt_s *o ;
	char *p, cmdline[1000] ;

	o = (opt_s *) dane ;

	p = set_options(signal) ;
	if(!p) return ;
	sprintf(cmdline, "%s %s >%s 2>%s", p, o->input.tmpfil, 
		o->output.tmpfil,
		o->error.tmpfil) ;

	free(p) ;
	execute(cmdline, o) ;
}


/* appends programs to the main program menu bar */
void append_programs(opt_s *o) {
	GtkItemFactoryEntry element = {NULL, NULL,	program_select,	0} ;
	GtkWidget *w ;
	char *t, *path, tmp1[100] ;
	int nprogs, i ;

	nprogs = sizeof(programs) / sizeof(programopt_s) ;
	printf("N of progs %i\n", nprogs) ;

	for(i = 0 ; i < nprogs ; i++ ) {

		if( !(t = strrchr(programs[i].progname, '_')) )
			t = programs[i].progname ;
		t++ ;

		sprintf(tmp1, "/Programs/_%c %s", i + 97, t) ;
		element.path = tmp1 ;
		element.callback_action = i ;

		gtk_item_factory_create_items(o->fabryka, 1, &element, o) ;
		/* 
		w = gtk_item_factory_get_widget(o->fabryka, element.path) ;
		if(w != NULL) 
			gtk_tooltips_set_tip(o->tips, w, programs[i].description, "aha") ;
		*/
	}
}


/* clickin on "check" button calls this function, which records the change */
void toggle_optstat(GtkWidget *kontr, gpointer dane) {
	int *ip ;

	ip = (int *) dane ;
	*ip = ! *ip ;
}

/* called if "OK" in the option dialog is pressed. Computates the option line */
void close_options(GtkWidget *kontr, gpointer dane) {
	data_s *d ;
	int i, j, *optstat ;
	char *optvalue, *res, tmp[100] ;
	programopt_s *p ;
	GtkWidget **o ;

	/* casting data-to-be-processed into apriopriate types */
	d = (data_s *) dane ;
	p = (programopt_s *) d->data1 ;
	optstat = (int *) d->data2 ;
	o = (GtkWidget **) d->data3 ;

	res = malloc(1000) ; /* yeah I know this is evil */
	sprintf(res, "%s ", p->progname) ;

	/* for each option... */
	for(i = 0, j = 0 ; res && i < p->nopts ; i++, j++) {

		/* if the option has an argument, we read the editable entry */
		if( p->optstr[j + 1] == ':' ) {
			optvalue = gtk_editable_get_chars(GTK_EDITABLE(o[i]), 0, -1) ;

			/* if the user entered anything */
			if(strlen(optvalue)) {
				sprintf(tmp, "-%c %s ", p->optstr[j], optvalue) ;
				strcat(res, tmp) ;
			}

			j++ ;
		} else {
		/* if not, we just check the button state as recorded by "toggle" function */
			/* if the user checked the option */
			if(optstat[i]) { 
				sprintf(tmp, "-%c ", p->optstr[j]) ;
				strcat(res, tmp) ;
			}
		}

	}

	gtk_widget_destroy(d->window1) ;
	gtk_main_quit() ;
	d->data = res ;
}


/* produces a dialog for choosing option for a given program and returns the
 * programs option string */
char* set_options(int wh) {
	GtkWidget *sep, *label, *okno, *ypole, *hpole, *optlab, **opsent, *ok, *cancel ;
	int i, j, *optstat ;
	char *res = NULL ;
	data_s d ;

	/* reserving space for arrays holding option states and option entries */
	opsent = malloc(sizeof(*opsent) * programs[wh].nopts) ;
	optstat = malloc(sizeof(*optstat) * programs[wh].nopts) ;

	/* this structure will hold the data passed to close_options() */
	d.data = NULL ;
	d.data1 = &programs[wh] ;
	d.data2 = optstat ;
	d.data3 = opsent ;

	/* main option window */
	okno = gtk_window_new(GTK_WINDOW_DIALOG) ;
	gtk_window_set_title(GTK_WINDOW(okno), programs[wh].progname) ;
	gtk_widget_show(okno) ;
	gtk_signal_connect(GTK_OBJECT(okno), "destroy",
		GTK_SIGNAL_FUNC(gtk_main_quit), okno) ;

	d.window1 = okno ;

	ypole = gtk_vbox_new(FALSE, 5) ;
	gtk_container_add(GTK_CONTAINER(okno), ypole) ;
	gtk_widget_show(ypole) ;

	label = gtk_label_new(programs[wh].description) ;
	gtk_box_pack_start(GTK_BOX(ypole), label, FALSE, FALSE, 2) ;
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE) ;
	gtk_widget_show(label) ;

	sep = gtk_hseparator_new() ;
	gtk_widget_show(sep) ;
	gtk_box_pack_start(GTK_BOX(ypole), sep, FALSE, FALSE, 2) ;

	/* for each option, we create a widget stored in opsent and record a state in
	 * optstat */
	for(i = 0, j = 0 ; i < programs[wh].nopts ; i++, j++) {

		optstat[i] = 0 ;

		/* for options containing a parameter -- an entry box */
		if( programs[wh].optstr[j + 1] == ':' ) {

			hpole = gtk_hbox_new(FALSE, 5) ;
			gtk_box_pack_start(GTK_BOX(ypole), hpole, FALSE, FALSE, 2) ;
			gtk_widget_show(hpole) ;
			j++ ;
			opsent[i] = gtk_entry_new() ;
			gtk_box_pack_start(GTK_BOX(hpole), opsent[i], FALSE, FALSE, 0) ;
			gtk_widget_show(opsent[i]) ;

			optlab = gtk_label_new(programs[wh].optdesc[i]) ;
			gtk_box_pack_start(GTK_BOX(hpole), optlab, FALSE, FALSE, 0) ;
			gtk_label_set_justify(GTK_LABEL(optlab), GTK_JUSTIFY_LEFT) ;
			gtk_label_set_line_wrap(GTK_LABEL(optlab), TRUE) ;
			gtk_widget_show(optlab) ;

		/* for simple options -- a check box */
		} else {
			
			opsent[i] = gtk_check_button_new_with_label(programs[wh].optdesc[i]) ;
			gtk_box_pack_start(GTK_BOX(ypole), opsent[i], FALSE, FALSE, 5) ;
			gtk_signal_connect(GTK_OBJECT(opsent[i]), "toggled",
				GTK_SIGNAL_FUNC(toggle_optstat), &optstat[i]) ;
			gtk_widget_show(opsent[i]) ;
		}

	}

	/* separator + OK + cancel buttons */
	sep = gtk_hseparator_new() ;
	gtk_widget_show(sep) ;
	gtk_box_pack_start(GTK_BOX(ypole), sep, FALSE, FALSE, 5) ;

	hpole = gtk_hbox_new(FALSE, 5) ;
	gtk_widget_show(hpole) ;
	gtk_box_pack_start(GTK_BOX(ypole), hpole, FALSE, FALSE, 5) ;

	ok = gtk_button_new_with_label("OK") ;
	gtk_widget_show(ok) ;
	gtk_box_pack_start(GTK_BOX(hpole), ok, FALSE, FALSE, 10) ;
	gtk_signal_connect(GTK_OBJECT(ok), "clicked",
		GTK_SIGNAL_FUNC(close_options), &d) ;

	cancel = gtk_button_new_with_label("Cancel") ;
	gtk_widget_show(cancel) ;
	gtk_box_pack_start(GTK_BOX(hpole), cancel, FALSE, FALSE, 10) ;
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
		GTK_SIGNAL_FUNC(zakoncz_dialog), okno) ;

	gtk_main() ;

	/* the resulting command line gets stored by close_options() in d.data */
	res = (char*) d.data ;
	if(res) printf("command line: %s \n", res) ;
	return res ;
}
