#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include "main.h"


/* reads lines from a file and stores them in a GList */
GList * get_items_from_file(char *file) {
	FILE *fp ;
	char *a, *b, *c, bufor[BUFSIZ] ;
	GList *res ;
	int i = 0 ;

	if( !(fp = fopen(file, "r")) ) {
		Warn("cannot open %s", file) ;
		return NULL ;
	}

	res = NULL ;

	/* reading file line by line */
	while( fgets(bufor, BUFSIZ, fp) ) {
		i++ ;
		/* skipping blanks and comments */
		if(*bufor == '\n' || *bufor == '#') continue ;
		if( (c = strchr(bufor, '\n')) ) *c = '\0' ;
		a = my_strdup(bufor) ;
		res = g_list_append(res, a) ;
	}

	Warn("%i entries read from file %s", i, file) ;
	fclose(fp) ;
	return res ;
}


/* save a GList to a file */
int put_items_to_file(char *file, GList *list, int items) {
	char *tmp ;
	FILE *fp ;
	int i, j, k, l ;

	/* open the file */
	if( !(fp = fopen(file, "w")) ) {
		Warn("Could not open file %s for writing", file) ;
		return EXIT_FAILURE ;
	}

	/* how many *last* items to write. (items == 0) => all */
	l = g_list_length(list) ;
	if(l > items && items != 0) 
		j = (l - items) ; 
	else 
		j = 0 ;

	for(i = j, k = 0; i < l ; i++, k++) {
		tmp = g_list_nth_data(list, i) ;
		fprintf(fp, "%s\n", tmp) ;
	}

	Warn("put_items_to_file: wrote %i items", k) ;
	fclose(fp) ;
	return EXIT_SUCCESS ;	
}


/* writes the new configuration file */
int write_rcfile(opt_s *o) {
	char *path, *tmp, bufor[BUFSIZ], *rcfile, *rcdir ;
	FILE *rc ;
	int i, j, l ;
	time_t date ;

	if(! (rcdir = my_strdup(getenv("HOME"))) ) {
		Warn("$HOME variable absent") ;
		return EXIT_FAILURE ;
	}
	
	rcdir = realloc(rcdir, strlen(rcdir) + strlen(ARKA_DIR) + 1) ;
	strcat(rcdir, ARKA_DIR) ;
	rcfile = malloc(strlen(rcdir) + 50) ;

	/* saves command history */
	strcpy(rcfile, rcdir) ;
	strcat(rcfile, "/command_history") ;

	Warn("saving command history...") ;
	if(o->command_history) {
		put_items_to_file(rcfile, o->command_history, 20) ;
	} else {
		Warn("no command history recorded") ;
	}

	/* saves file history */
	strcpy(rcfile, rcdir) ;
	strcat(rcfile, "/file_history") ;

	Warn("saving file history...") ;
	if(o->file_history) {
		put_items_to_file(rcfile, o->file_history, 5) ;
	} else {
		Warn("no file history recorded") ;
	}

	free(rcdir) ;
	free(rcfile) ;
	return EXIT_SUCCESS ;
}


/* reads the configuration file */
int read_rcfile(opt_s *o) {
	char *path, *tmp, bufor[BUFSIZ], *rcfile, *rcdir ;
	FILE *rc ;
	struct stat statbuf ;

	Warn("reading configuration") ;

	/* getting rc directory */
	if(! (rcdir = my_strdup(getenv("HOME"))) ) {
		Warn("$HOME not present. No configuration file read") ;
		return EXIT_FAILURE ;
	}

	rcdir = realloc(rcdir, strlen(rcdir) + strlen(ARKA_DIR) + 1) ;
	strcat(rcdir, ARKA_DIR) ;

	/* checking rc directory */
	if( stat(rcdir, &statbuf) < 0) { /* cannot stat rcdir */
	
		if(demand("Arka configuration directory is not present."
			"\nShould I create it for you?")) { /* ask user to confirm creation */

			/* creating directory with umask rwxr-xr-x */
			if(mkdir(rcdir, S_IRWXU | 00050 | 00005) < 0) {	
				/* checking whether mkdir worked */
				komunikat("Creating %s failed", rcdir) ;
				return EXIT_FAILURE ;
			}

		} else { /* user did not agree to create the configuration directory */
			return EXIT_FAILURE ;
		}

	} else {
		if(!S_ISDIR(statbuf.st_mode)) { /* can stat rcdir, but is not a directory */
			komunikat("%s exists, but it is not a directory.\n"
				"Remove it if you plan to use a configuration file", rcdir) ;
			return EXIT_FAILURE ;
		}
	}

	Warn("configuration directory %s found", rcdir) ;
	rcfile = malloc(strlen(rcdir) + 50) ;

	/* reading command history */
	strcpy(rcfile, rcdir) ;
	strcat(rcfile, "/command_history") ;
	o->command_history = get_items_from_file(rcfile) ;

	/* reading file history */
	strcpy(rcfile, rcdir) ;
	strcat(rcfile, "/file_history") ;
	o->file_history =  get_items_from_file(rcfile) ;

	/* reading configuration */
	strcpy(rcfile, rcdir) ;
	strcat(rcfile, "/configuration") ;

	if( !(rc = fopen(rcfile, "r")) ) {
		Warn("No configuration file (%s) found\n", rcfile) ;
	} else {
		fclose(rc) ;
	}

	free(rcdir) ;
	free(rcfile) ;
	
	return EXIT_SUCCESS ;
}
