#define DEBUG 0

#define MAXSTR 500
#define MAXNAZWA 100
#define MAXLEN 9
#define QUIET 0
#define DEBUG 0

#ifndef TRUE
	#define TRUE 1
#endif
#ifndef FALSE
	#define FALSE 0
#endif

/* if national language support is defined, we use it */
#ifdef NLS
	#include <libintl.h>
	#define _(string) gettext (string)
#else
	#define _(string) (string)
	#define bindtextdomain(string)
	#define textdomain(string)
#endif

/* if zlib library is not used, we must discard some gz specific functions */
#ifdef GZ
	#include <zlib.h>
#else
	#define gzFile FILE
	#define gzgetc getc
	#define gzdopen fdopen
	#define gzopen fopen
	#define gzgets(arg1,arg2,arg3) fgets(arg2,arg3,arg1)
	#define gzclose fclose
	#define gzseek fseek
#endif

#ifndef RAND_MAX
	#define RAND_MAX (2147483647)
#endif

/* default data directory */
#ifndef DDIR
	#define DDIR "/usr/lib/genpak"
#endif

char yesno[2][4]={ "no", "yes" } ;

/* 
 * This variable is set to true if all the warnings are supposed to be
 * printed to stdout at the end of the program.
 */


extern char stypes[5][10] ;
extern char one2three[128][4] ;
typedef struct {
  char tbl[4][4][4] ;
} codont ;

struct position_ss {
	long start ;
	long end ; 
	struct position_ss* next ; 
} ;

typedef struct position_ss position_s ;


/*
 * we need a structure to store all the warnings issued by the program
 * in case we need to print them all one at the time, that is when
 * html==TRUE.
 */

struct warnings_s {
  char warn[200] ;
  struct warnings_s *next ;
};

struct warnings_s *allwarnings ;
struct warnings_s *currentwarning ;

int quiet=QUIET, html=FALSE ;
char *progname ;

extern sekw*   gp_gzReadSeqFrag(gzFile *in, long start, long end) ;
extern sekw*   gp_gzReadWholeSequence(gzFile *in) ;
extern void    PrintAllWarnings(FILE* out) ;
extern void    Programming_Error() ;
extern void    InitializeOne2Three() ;
extern codont* LoadStandardTable() ;
extern sekw*   Dna2Protein(sekw *inseq, codont* intable, long start, int pedantic) ;
extern sekw*   CopySeqFrag(sekw * s, long start, long end) ;
extern int     FormatSeq(FILE* out, sekw* s, int width) ;
extern sekw*   ReadSeqFrag(FILE *in, long start, long end, int numseq) ;
extern sekw*   ReverseSequence(sekw* s) ;
extern sequence_type GetSeqType(sekw *s) ;
extern void    Error(char *message, ...) ;
extern void    Warn(char *message, ...) ;
extern char    Complement(char c) ;
extern int     Compare(char c1, char c2) ;
extern FILE*   TryOpen(char *file, char* type) ;
extern int     IsStartCodon(sekw *s, long p) ;
extern position_s *FindSeq(sekw *query, sekw *subject) ;
extern double  VarianceE(double sum, double sumofsquares, int number) ;
extern sekw*   ReadWholeSequence(FILE *in) ;
extern sekw* gp_free(sekw *s) ;
