#define PROGRAM "arka"
#define VERSION "0.06"
#define ARKA_PROG_NUM_MAX 200

#ifndef ARKA_PROGRAMS
	#define ARKA_PROGRAMS "/etc/arkarc"
#endif


#ifndef ARKA_DIR
	#define ARKA_DIR "/.arka"
#endif

#ifndef ARKA_GLOBAL
	#define ARKA_GLOBAL "/etc/arkarc"
#endif


typedef enum {UNKNOWN=0, DNA, RNA, PROTEIN, WRONG } sequence_type ;
#ifdef MAIN_C
	int debug = 0 ;
#else
	extern int debug ;
#endif

struct sekw_ss {
	char name[200] ;
	char *sequ ;
	long leng ;
	struct sekw_ss *next ;
	sequence_type type ; } ;

typedef struct sekw_ss sekw ;

typedef struct {
	GtkWidget * window ;
	GtkWidget * window1 ;
	GtkWidget * window2 ;
	GtkWidget * window3 ;
	GtkWidget * window4 ;
	gpointer data ; 
	gpointer data1 ; 
	gpointer data2 ; 
	gpointer data3 ; 
	gpointer data4 ;
	gpointer data5 ; } data_s ;


/* structure containing a frame with a text widget and two scrollbars */
typedef struct {
	int on ;
	int changed ;
	int overwrite ;
	char file ;
	char *filenam ;
	char tmpfil[FILENAME_MAX] ;
	char title[100] ;
	gchar *contents ;
	GtkWidget *parent ;
	GtkWidget *ramka ;
	GtkWidget *tabela ;
	GtkWidget *tekst ;
	GtkWidget *tmp ; } okno_s ;
	
/* structure holding all data about the current state of things */
typedef struct {
	char *wdir ;

	GtkWidget *okno ; /* main program window */
	GtkWidget *ypole ; /* main gtk_ybox in the program window */
	GtkWidget *status ; /* status line */
	GtkAccelGroup *shortcuts ;
	GtkItemFactory *fabryka ; /* gtk_item_factory containing main menu items */
	GtkTooltips *tips ;

	okno_s panels[3] ; /* stdin, stdout and stderr windows */

	char *font_name ; /* current font name */
	char *font_name_default ; /* default font name */
	GdkFont *czcionka ; /* current gdk_font */
	GdkColor *colors ; /* allocated colors */
	int ncolors ; /* number of allocated colors */
	GdkCursor *cursor_normal ; /* normal cursor */
	GdkCursor *cursor_wait ; /* wait cursor */

	GList *program_list ; /* all program descriptions */

	sekw *seqlist ; /* list of sequences */
	GList *command_history  ; /* command history */
	GList *file_history  ; /* file history */
	int command_history_size ; /* how many command history items to save */
	int file_history_size ; /* how many file history items to save */

	int editable ; /* is the input editable? */
	int show_tooltips ; /* show tooltips? */

	GtkWidget *tmp ; /* temporary data */
} opt_s ;


/* types of options */
typedef enum { BOOLEAN, INT, DOUBLE, STRING, FILENAME, HIDDEN } opttypes_t ;

/* structure holding options for one of the program entries */
typedef struct {
	GtkWidget *widget ;

	char *designator ; /* designator, e.g. "-h" */
	char *description ; /* option description */
	char *defvalue ; /* default value */
	int set ; /* is the option on? */

	char *strvalue ; /* string value */
	double doublevalue ; 
	int intvalue ;

	int required ; /* is the option required? */
	opttypes_t type ; /* type of the option */

	opt_s *main_opts ; /* opt_s */
} entry_option_s ;


/* structure holding entry */
typedef struct {
	int number ; /* current number */
	char *name ; /* program name */
	char *menupath ; /* item factory menu path */
	char *entry ; /* entry in the menu */
	char *branch ; /* branch of the entry */
	char *short_description ; /* short program description */
	char *long_description ; /* long description of the program */
	int nopts ; /* how many options */
	GList *options ; /* list with options */
} entry_s ;



/* interface.c */
GtkWidget *create_separator(GtkWidget *parentbox) ;
GtkWidget *create_label(GtkWidget *parentbox, char* label) ;
GtkWidget *create_hbox(GtkWidget *parentbox) ;
GtkWidget *create_combo(GtkWidget* parentbox, char *label, char *items[], int n) ;
GtkWidget *create_list(GtkWidget* parentbox, char *label, char *items[], int n) ;
GtkWidget *create_button(GtkWidget *box, gpointer func, char* label, gpointer data) ;
GtkWidget* create_text(GtkWidget *parentbox, char* text, int editable) ;
GtkWidget* create_option_widget(GtkWidget *parentbox, int type, char* description) ;

void file_select(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void destroy_dialog(GtkWidget *okno, gpointer dane) ;
void close_dialog(GtkWidget *kontrolka, gpointer dane) ;
void zakoncz_dialog(GtkWidget *kontrolka, gpointer dane) ;
void pokaz(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void toggle_editable(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void set_font(GtkWidget *okno, opt_s *o) ;
void select_font(opt_s *o) ;
void change_font(opt_s *o) ;
void set_style_recursive(GtkWidget *okno, gpointer dane) ;
void redraw_text(opt_s *o) ;
void inicjuj_menu(opt_s *o) ;
void make_ramka(GtkWidget *kontrolka, okno_s *o) ;
void inicjuj_main_window(opt_s *o) ;
void toggle_windows(gpointer dane, guint signal, GtkWidget *kontrolka) ;
int append_single_entry(opt_s *o, char *filen, int i) ;
char *get_font_name(opt_s *o, char *name) ;

  
/* graph.c */
void graph_gc(gpointer dane, guint signal, GtkWidget *kontrolka) ;

/* main.c */
int write_text(char *text, okno_s *okno, opt_s *o) ;
int execute(char *comline, opt_s *o) ;
void command(gpointer dane, guint signal, GtkWidget *kontrolka) ;

/* graph3d.c */
void graph3d_create_from_file(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void graph3d_create_from_input(gpointer dane, guint signal, GtkWidget *kontrolka) ;

/* file.c */
int read_file(FILE *fp, opt_s *o, okno_s *okno) ;
char *file_get_name(opt_s *o, char *default_name) ;
void file_select(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void save_file(GtkWidget *k, gpointer dane) ;
void open_file(GtkWidget *k, gpointer dane) ;
int window_tofile(okno_s *okno, opt_s *o) ;
void file_save_as(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void file_save(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void file_open(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void file_open_from_list(gpointer dane, guint signal, GtkWidget *kontrolka) ;

/* komunikat.c */
void komunikat(char *tekst, ...) ;
int demand(char *tekst, ...) ;
int demand_complex(GtkWidget *widget, gpointer func, data_s* data, char *tekst, ...) ;

/* rcfile.c */
int read_rcfile(opt_s *o) ;
int write_rcfile(opt_s *o) ;

/* programs.c */
char *my_strdup(char *string) ;
char *my_strsubst(char *string, char *from, char *to) ;
void program_create(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void program_select(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void programs_append(opt_s *o) ;
char* set_options(int wh, opt_s *o) ;
GtkWidget* set_widget_for_option(entry_option_s *o, GtkWidget *parentbox) ;

/* help.c */
void help_display_man(GtkWidget *kontr, gpointer dane) ;
void help_text(gpointer dane, guint signal, GtkWidget *kontrolka) ;
void help_about(gpointer dane, guint signal, GtkWidget *kontrolka) ;
GtkWidget * popup_at_start(opt_s *o) ;

/* options.c */
int options_initialize(opt_s *opt) ;
void options_preferences_set(gpointer dane, guint signal, GtkWidget *kontrolka) ;
