/* setting up the global program options */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include "main.h"

typedef struct {
	GtkWidget *okno ;
	GtkWidget *hist_button ;
	GtkWidget *file_button ;
	GtkWidget *font_label ;
	opt_s *o ;
} preferences_s ;


/* to reuse the code, default option vals + descripts are hold in entry_option_s */
entry_option_s options[] = {
	{ NULL, NULL, "command history items to store", "20", 1, NULL, 0.0, 20, 1, INT, NULL } ,
	{ NULL, NULL, "file history items to store", "5", 1, NULL, 0.0, 5, 1, INT, NULL } ,
	{ NULL, NULL, "hide tooltips", "0", 0, NULL, 0.0, 0, 0, BOOLEAN, NULL } 
} ;


/* set up default option values on start */
int options_initialize(opt_s *opt) {
	int i ;

	opt->editable = FALSE ;
	opt->show_tooltips = TRUE ;
	opt->tips = gtk_tooltips_new() ;

	opt->font_name_default = my_strdup("-*-courier-medium-r-*-*-*-*-*-*-*-*-*-*") ;
	opt->font_name = my_strdup(opt->font_name_default) ;
	opt->czcionka = gdk_font_load(opt->font_name_default) ;

	if(!opt->czcionka) opt->czcionka = (gtk_widget_get_default_style())->font ;

	opt->file_history = NULL ;
	opt->program_list = NULL ;

	opt->command_history = NULL ;
	opt->command_history = g_list_append(opt->command_history, "ls -l %input") ;
	opt->command_history = g_list_append(opt->command_history, "wc -c %input") ;

	opt->command_history_size = 20 ;
	opt->file_history_size = 5 ;

	opt->wdir = my_strdup(getenv("PWD")) ;
	opt->wdir = realloc(opt->wdir, strlen(opt->wdir) + 2000) ;
	strcat(opt->wdir, "/") ;

	if(opt->wdir != NULL) printf("Working directory %s\n", opt->wdir) ;

	/* setting up the main three text panels */
	for(i = 0 ; i < 3 ; i++) {
		opt->panels[i].on = TRUE ;
		opt->panels[i].changed = FALSE ;

		/* we need temporary files for the gp programs to use */
		sprintf(opt->panels[i].tmpfil,"/tmp/tescik-%iXXXXXX", i) ;

		if(mktemp(opt->panels[i].tmpfil) == NULL) {
			komunikat("One or more of the temporary files could not be created.\n"
		 		"Since they are absolutely necessary, arka will now exit. Sorry.") ;
			exit(1) ;
		}

		opt->panels[i].filenam = NULL ;
	}

	/* each time a file is loaded, input gets erased; but error and output windows
	 * accumulate the produced data */
	opt->panels[0].overwrite = TRUE ;
	opt->panels[1].overwrite = FALSE ;
	opt->panels[2].overwrite = FALSE ;

	opt->cursor_normal = gdk_cursor_new(GDK_ARROW) ;
	opt->cursor_wait = gdk_cursor_new(GDK_WATCH) ;

	return EXIT_SUCCESS ;
}


/* ---------------------------- preferences dialog ---------------------- */
void options_get_font(GtkWidget *kontr, gpointer dane) {
	preferences_s *pref ;
	opt_s * o ;
	char *fontname ;

	pref = (preferences_s *) dane ;

	o = pref->o ;

	fontname = get_font_name(o, o->font_name) ;

	Warn("setting default font name to %s", fontname) ;

	if(fontname) {
		gtk_label_set_text(GTK_LABEL(pref->font_label), fontname) ;
		if(o->font_name_default) free(o->font_name_default) ;
		o->font_name_default = fontname ;
		if(o->font_name) free(o->font_name) ;
		o->font_name = my_strdup(fontname) ;

		o->czcionka = gdk_font_load(fontname) ;
	}

}


/* closing the preferences dialog and storing the options */
void options_preferences_close(GtkWidget *kontr, gpointer dane) {
	preferences_s *pref ;
	opt_s * o ;

	pref = (preferences_s *) dane ;

	o = pref->o ;

	o->command_history_size =
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(options[0].widget)) ;
	o->file_history_size =
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(options[1].widget)) ;

	if(options[1].widget) {
		o->show_tooltips = FALSE ;
		gtk_tooltips_disable(o->tips) ;
	} else {
		o->show_tooltips = TRUE ;
		gtk_tooltips_enable(o->tips) ;
	}

	gtk_widget_destroy(pref->okno) ;
	
	gtk_main_quit() ;
	write_rcfile(o) ;
	redraw_text(o) ;
}


/* setting up the preferences dialog */
void options_preferences_set(gpointer dane, guint signal, GtkWidget *kontrolka) {
	GtkWidget *sep, *hpole, *ypole, *label, *notebook, *ok, *cancel ;
	preferences_s pref ;
	int nopts, i ;

	nopts = sizeof(options) / sizeof(entry_option_s) ;
  pref.o = (opt_s *) dane ;

	Warn("main preferences dialog") ;
	
	pref.okno = gtk_window_new(GTK_WINDOW_DIALOG) ;
	gtk_window_set_title(GTK_WINDOW(pref.okno), "Preferences") ;
	ypole = gtk_vbox_new(FALSE, 5) ;

	label = gtk_label_new("Main") ;

	notebook = gtk_notebook_new() ;
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), ypole, label) ;
	gtk_container_add(GTK_CONTAINER(pref.okno), notebook) ;

	/* updating options */
	options[0].intvalue = pref.o->command_history_size ;
	options[1].intvalue = pref.o->file_history_size ;
	options[2].set = !(pref.o->show_tooltips) ;

	/* same mechanism as in the programs menu -- to recycle the code */
	for(i = 0 ; i < nopts ; i++) {
		options[i].widget = set_widget_for_option(&options[i], ypole) ;
	}

	hpole = create_hbox(ypole) ;
	pref.font_label = create_label(hpole, pref.o->font_name_default) ;
	create_button(hpole, options_get_font, "Select Font", &pref) ;

	/* separator + OK + cancel buttons */
	create_separator(ypole) ;
	hpole = create_hbox(ypole) ;

	/* ok and cancel buttons */
	ok = create_button(hpole, options_preferences_close, "  Save  ", &pref) ;
	create_button(hpole, zakoncz_dialog, "  Cancel  ", pref.okno) ;

	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT) ;
	gtk_widget_grab_default(ok) ;
	gtk_widget_show_all(pref.okno) ;
	gtk_main() ;

}
