static char readme[] = "\n"
"1. About Arka\n"
"2. How to use Arka\n"
"3. Config files\n"
"4. Problems, bugs, maintainer\n"
"\n"
"\n"
"1. About Arka\n"
"\n"
"Arka is a program that (1) serves as a graphical interface for the programs\n"
"from the GP package (see http://www.bioinformatics.org/genpak/) and virtually\n"
"for any other command line program (2) has some funtions on it's one. Main scope\n"
"of the program is the manipulation and visualisation of DNA / RNA / protein\n"
"sequences.\n"
"\n"
"The GP package contains many command-line utilities which fullfill a whole bunch\n"
"of tasks (from DNA sequence searches to restriction analysis and determining the\n"
"melting temperature of oligonucleotides). While those programs are convenient to\n"
"use in batch processing and CGI scripts (which was the purpose of those\n"
"programs), they lack a nice GUI. \n"
"\n"
"Arka remembers the options for the GP programs and knows what both the programs\n"
"and the options do. Besides, it has some gadgets on its own. It requires GTK+,\n"
"but doesn't need GNOME. Also, it is small and quick: look, I write and use my\n"
"programs on an old 486 laptop. It should run like hot butter on your computer.\n"
"Unless, of course, it is a 386 SX.\n"
"\n"
"\n"
"2. How to use Arka\n"
"\n"
"2.1 Arka window\n"
"\n"
"The main window of the program consists of three sub-windows. They are called\n"
"'input', 'output' and 'error' and correspond to stdin, stdout and stderr. In\n"
"other words, 'input' window contains the data which are fed into the used GP\n"
"program; when you run the program, it's output is stored in the 'output' window\n"
"and any error messages issued are stored in the 'error' window. You can load\n"
"just any text file into the 'input' window -- a FASTA formatted sequence, a\n"
"matrix, a list of parameters. Anything goes. However, if you run a GP program\n"
"and it doesn't find in the input what it expects (for example, gp_gc expects a\n"
"DNA / RNA sequence), you will get an error message in the 'error' window.\n"
"\n"
"2.2. Menus\n"
"\n"
"I think I don't have to explain what the 'File' and 'Options' menus do. Just\n"
"note that the entry field in a 'file' dialog is nearly as potent as a bash\n"
"commandline: it supports file extension with TAB, ctrl-e, ctrl-a, ctrl-u etc.\n"
"Another nice feature of the gtk+ toolkit: in each menu, you see a dashed line on\n"
"the top of the menu. This is called a 'tearoff' -- try clicking on it and you\n"
"will get a separate 'toolbox' window. This is so much more efficient than\n"
"standard toolboxes!\n"
"\n"
"The 'Tools' menu contain gadgets specific for the Arka program. 'GC graph'\n"
"draws a GC contents graph based on the sequences in the 'input' window. This\n"
"tool expects FASTA sequences in the 'input' window. '3D graph' draws a\n"
"complicated 3D graph (I am very proud on this thing: I have re-invented the\n"
"z-buffer). The file to draw should have in each line three tab-separated\n"
"numbers: the x,y,z coordinates of the data point to draw; optionally, you can\n"
"also place an integer number designating the class of the data point (each class\n"
"will be drawn with another color) and a label (string) for that point. Empty\n"
"lines or lines starting with a '#' are ignored. Here is an example:\n"
"\n"
"# x	y	z	class	label\n"
"1.9	2.0	-1.5	8	some point\n"
"\n"
"'Command...' runs for you any arbitrary command (any program you can run from a\n"
"normal command line). It stores the command history in the Arkas configuration\n"
"file. You can treat the text contained in the 'input' window just like a normal\n"
"file -- just put a '%s' where you would put the file's name, for example try to\n"
"enter something like that:\n"
"\n"
"wc -l %s\n"
"\n"
"...and you will get the number of the lines in the 'input' window.\n"
"\n"
"'Windows' lets you currently only hide / show the three main windows and even\n"
"this doesn't work all to well.\n"
"\n"
"'Programs' contains a list of the GP package programs. If you choose one, you\n"
"will see a brief summary of what the program does and an entry + description for\n"
"each relevant option the program supports. \n"
"\n"
"Guess what the 'help' menu does, or, rather, should do but doesn't (not yet).\n"
"\n"
"\n"
"3. Config files.\n"
"\n"
"There is the global config file, /etc/arkarc, and a user directory,\n"
"$HOME/.arkarc/, which contains a config file (configuaration; not yet!),\n"
"command_history, file_history and (possibly) a file called `programs'.\n"
"\n"
"The trick arka uses to do its work is as follows: arka stores the input window\n"
"in a temporary file, and then passes the name of this temporary file to the\n"
"program it runs. To be more specific, it builds the command line from the\n"
"options and arguments shown in the dialog box, and replaces each string of the\n"
"following form:\n"
"%input\n"
"...with the name of the temporary file. So, wherever you'd like to put the\n"
"contents of your input window, and the program run expects a file -- you put a\n"
"'%input' and the program will get its file. \n"
"\n"
"While running the program, arka catches its stdout into another temporary file,\n"
"and dumps its contents to the 'output' window. The stderr gets caught into yet\n"
"another temp file, and dumped to 'error' window.\n"
"\n"
"How does arka know how to run a program? The answer is -- it reads its detailed\n"
"descriptions stored in one of the two files, /etc/arkarc (take a look at it),\n"
"and $HOME/.arka/programs. You can write your one spec files for just any\n"
"command-line programs of your choice. \n"
"\n"
"But beware: if the program is trying to read standard input, arka will hang --\n"
"because it waits for the program to finish, and the program is waiting for an\n"
"input -- which it doesn't get.\n"
"\n"
"\n"
"4. Problems, bugs, maintainer\n"
"\n"
"I wonder whether these tools will be useful to anyone but me. On the other hand,\n"
"they are useful for me (I wrote Arka because I couldn't remember all the\n"
"options of the programs I wrote, and because I needed the 3D graph part to\n"
"visualise DNA structures). So, whether you like the program or not, please do\n"
"mail me (like, to save me the effort of writing another README file). My address\n"
"is january@bioinformatics.org; programs homepage is\n"
"http://www.bioinformatics.org/genpak/.\n" ;
