#define DEBUG 0

#define MAXSTR 500
#define MAXNAZWA 100
#define MAXLEN 9
#define QUIET 0
#define DEBUG 0
#define TRUE 1
#define FALSE 0

/* if national language support is defined, we use it */
#ifdef NLS
	#include <libintl.h>
	#define _(string) gettext (string)
#else
	#define _(string) (string)
	#define bindtextdomain(string)
	#define textdomain(string)
#endif

/* if zlib library is not used, we must discard some gz specific functions */
#ifdef GZ
	#include <zlib.h>
#else
	#define gzFile FILE
	#define gzgetc getc
	#define gzdopen fdopen
	#define gzopen fopen
	#define gzgets(arg1,arg2,arg3) fgets(arg2,arg3,arg1)
	#define gzclose fclose
	#define gzseek fseek
	#define gp_gzOpen gp_file_open
	#define gp_gzReadWholeSequence gp_seq_read
	#define gp_gzReadSeqFrag gp_seq_read_fragment
#endif

/* default data directory */
#ifndef DDIR
	#define DDIR "/usr/lib/genpak"
#endif

char yesno[2][4]={ "no", "yes" } ;

/* 
 * This variable is set to true if all the warnings are supposed to be
 * printed to stdout at the end of the program.
 */

int debug=DEBUG, quiet=QUIET, html=FALSE ;
char *progname ;

typedef enum {UNKNOWN=0, DNA, RNA, PROTEIN, WRONG } sequence_type ;

extern char stypes[5][10] ;
extern char one2three[128][4] ;

/* structure type for sequences */
struct _sekw {
	char *name ;
	char *sequ ;
	long leng ;
	struct _sekw *next ;
	struct _sekw *prev ;
	sequence_type type ; } ;

typedef struct _sekw sekw ;


typedef struct {
  char tbl[4][4][4] ;
} codont ;


/* structure for storing positions as linked lists */
struct _position_s {
	long start ;
	long end ; 
	struct _position_s *next ; } ;

typedef struct _position_s position_s ;



/*
 * we need a structure to store all the warnings issued by the program
 * in case we need to print them all one at the time, that is when
 * html==TRUE.
 */

struct warnings_s {
  char warn[200] ;
  struct warnings_s *next ;
};

struct warnings_s *allwarnings ;
struct warnings_s *currentwarning ;


/* Function prototypes */

char              gp_nucl_complement(char c) ;

void              gp_warn(char *message, ...) ;
void              gp_warn_print_all(FILE *out) ;
void              gp_error(char *message, ...) ;
void              gp_error_fatal() ;

void              gp_codon_init_conversion() ;
int               gp_codon_isstart(sekw *s, long p) ;
codont*           gp_codon_table_load_std() ;

void              gp_seq_free(sekw *s) ;
int               gp_seq_print_fasta(FILE* out, sekw* s, int width) ;
sekw*             gp_seq_read_fragment(FILE *in, long start, long end, int numseq) ;
sekw*             gp_seq_read(FILE *in) ;
sekw*             gp_seq_reverse(sekw* s) ;
sekw*             gp_seq_copy_frag(sekw * s, long start, long end) ;
position_s*       gp_seq_find(sekw *query, sekw *subject) ;
sequence_type     gp_seq_get_type(sekw *s) ;
sekw*             gp_seq_dna_to_protein(sekw *inseq, 
                         codont* intable, 
												 long start, 
												 int pedantic) ;

FILE*             gp_file_open(const char *filename, const char *type) ;
double            gp_variance_e(double sum, double sumofsquares, int number) ;
char*             gp_strdup(char *s) ;

void Help() ;
