/* ----------------------------------------------------------------------
 * pars -- substitute newline characters from HTML output
 * Copyright (C) 2000 January Weiner III
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 ---------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "genpak.h"
#include "gp_getopt.h"

#define VERSION "1.0"
#define PROGNAME "pars"

void Help() ;

/*
 * tiny program for parsing of the html GET method to use in CGI scripts
 */

int main(int argc, char *argv[]) {

	extern int optind ;
	extern char *optarg ;

	char dupa[7] = "%0D%0A", temp[7] ;
	

	FILE *in = stdin, *out = stdout ;
	int t = FALSE, i = 0, c, l = 6 ;

	while ((c = gp_getopt(argc, argv, "ht")) != EOF)
		switch(c) {
		case 'h':
			Help() ;
			exit(EXIT_SUCCESS) ; 
			break ;
		case 't':
			t = TRUE ;
			break ;
		default:
			exit(1) ;
			break ;
		}




	while((c = fgetc(in))!= EOF) {
		i = 0 ;

		if( (!t) && c == '%') {
			temp[0] = c ;
			for(i = 1;i<l && c!= EOF;i++) {
				temp[i] = fgetc(in) ;
				if(dupa[i]!= temp[i]) {
					temp[i+1] = '\0' ;
					fprintf(out,"%s",temp) ;
					c = fgetc(in) ;
					i = l+1;
				}
			}
		} 

		if(!t && i == l) fprintf(out,"\n") ;
		else 
			if(t && c == '&') fprintf(out,"\n") ; 
			else fprintf(out,"%c",c) ;
	}

	fclose(out) ;
	fclose(in) ;
	return(EXIT_SUCCESS);
}

void Help() {
	printf("gp_pars -- parse program for cgi scripts\n") ;
	printf("Usage:\n") ;
	printf(" gp_pars\n") ;
	printf("     filter standard input changing \"%%0D%%0A\" to newline\n") ;
	printf(" gp_pars -t\n") ;
	printf("     filter standard input changing '&' to newline\n") ;
}
