/* ----------------------------------------------------------------------
 * General purpose template file
 * Copyright (C) 2000 January Weiner III
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 ---------------------------------------------------------------------- */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>

#include "genpak.h"
#include "gp_getopt.h"

#define VERSION "template file"
#define PROGNAME "gp_template"

char *progname ;

typedef struct {
	FILE *in ;
	FILE *out ; 
	int width ;
} opt_s ;

/*
 *
 */

int main(int argc, char *argv[])
{
	extern int optind ;
	extern char *optarg ;
	opt_s options ;
	sekw *inseq, *outseq ;

	int c;
	char message[100] ;

	progname = argv[0] ;
	options.width = 70 ;

	while ((c = gp_getopt(argc, argv, "Hqdvh")) != EOF)
		switch(c) {
		case 'H':
			html = TRUE ;
			break ;
		case 'q':
			quiet = TRUE ;
			break ;
		case 'v':
			fprintf(stderr,"%s version %s\n", progname, VERSION) ;
			exit(EXIT_SUCCESS) ;
			break ;
		case 'd':
			debug = TRUE ;
			gp_warn("Running in debug mode") ;
			break ;
		case 'h':
			Help() ;
			break ;
		default:
			gp_error("Type '%s -h' for help", progname) ;
			break;
		}


/* open the file pointer to read the sequences 
 * from: standard input or a file provided? */
	if(optind >= argc) options.in = stdin ;
	else options.in = gp_file_open(argv[optind],"r") ;

/* opening the file pointer to write the output: 
 * standard output or file provided? */
	optind++ ;

	if(optind >= argc) options.out = stdout ;
	else options.out = gp_file_open(argv[optind],"wb") ;
	
	if(html) gp_warn_print_all(options.out) ;
	fclose(options.out) ;
	fclose(options.in) ;
	return EXIT_SUCCESS ;
}


/* Standard mesage */
void Help()
{
	fprintf(stdout, ""
	"\n"
	"%s, v. %s- no description yet"
	"\n"
	"  Usage:\n"
	"     %s [options] [ input file ] [ output file ]\n"
	"\n"
	"  Options:\n"
	"     -v       : print version information & exit\n"
	"     -h       : print this help screen & exit\n"
	"     -q       : quiet, suppress error messages\n\n"),
	PROGNAME,VERSION,progname;
	exit(EXIT_SUCCESS);
}


			
