# Mavric -- a module for manipulating and visualizing phylogenies

# Copyright (C) 2000 Rick Ree
# Email : rree@oeb.harvard.edu
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

from toolkit import *
from constants import *
from fileselection import SaveFileSelection, OpenFileSelection

class BaseApp(GnomeApp):

    def __init__(self, **kwargs):
        appname = kwargs.get('appname') or ''
        title = kwargs.get('title') or ''
        GnomeApp.__init__(self, appname=appname, title=title)

        self.connect('delete_event', self.quit)
        self.connect('destroy', self.quit)

        self.set_usize(100,100)
        width = screen_width()*0.66
        height = screen_height()*0.66
        self.set_default_size(width, height)

        self.appbar = GnomeAppBar()
        self.set_statusbar(self.appbar)

        save_file_selection = SaveFileSelection(self.save_file, self)
        save_file_selection.hide()
        self.save_file_selection = save_file_selection

        open_file_selection = OpenFileSelection(self.open_file, self)
        open_file_selection.hide()
        self.open_file_selection = open_file_selection

        self.file_menuinfo = [
            UIINFO_MENU_NEW_ITEM('New...', 'Create tree from scratch',
                                 cb = self.menuitem_new_cb),
            UIINFO_MENU_OPEN_ITEM(cb = self.menuitem_open_cb),
            UIINFO_MENU_SAVE_AS_ITEM(cb = self.menuitem_save_cb),
            UIINFO_SEPARATOR,
            UIINFO_MENU_PRINT_ITEM(cb = self.menuitem_print_cb),
            UIINFO_SEPARATOR,
            UIINFO_MENU_CLOSE_ITEM(cb = self.menuitem_close_cb),
            UIINFO_SEPARATOR,
            UIINFO_MENU_EXIT_ITEM(cb = self.menuitem_exit_cb)
        ]

        #self.edit_menuinfo = [
        #    UIINFO_MENU_CUT_ITEM(cb=self.menuitem_cut_cb),
        #    UIINFO_MENU_COPY_ITEM(cb=self.menuitem_copy_cb),
        #    UIINFO_MENU_PASTE_ITEM(cb=self.menuitem_paste_cb)
        #]

        self.view_menuinfo = [
            UIINFO_ITEM('Preferences...',
                        cb = self.menuitem_view_prefs_cb)
        ]

        self.help_menuinfo = [
            UIINFO_MENU_ABOUT_ITEM(cb=self.menuitem_about_cb)
        ]

        self.main_menuinfo = [
            UIINFO_SUBTREE('File', self.file_menuinfo),
            #UIINFO_SUBTREE('Edit', self.edit_menuinfo),
            UIINFO_SUBTREE('View', self.view_menuinfo),
            UIINFO_SUBTREE('Help', self.help_menuinfo)
        ]

    def quit(self, *args):
        mainquit()

    def mainloop(self):
        mainloop()

    def menuitem_new_cb(self, menuitem):
        self.menuitem_unimplemented_cb()

    def menuitem_open_cb(self, menuitem):
        self.open_file_selection.show()

    def menuitem_save_cb(self, menuitem):
        self.menuitem_unimplemented_cb()

    def menuitem_save_as_cb(self, menuitem):
        self.save_file_selection.show()

    def menuitem_print_cb(self, menuitem):
        self.menuitem_unimplemented_cb()

    def menuitem_close_cb(self, menuitem):
        self.save_file_selection.show()

    def menuitem_exit_cb(self, menuitem): self.quit()

    def menuitem_cut_cb(self, menuitem):
        self.menuitem_unimplemented_cb()

    def menuitem_copy_cb(self, menuitem):
        self.menuitem_unimplemented_cb()
        
    def menuitem_paste_cb(self, menuitem):
        self.menuitem_unimplemented_cb()

    def menuitem_view_prefs_cb(self, menuitem):
        self.menuitem_unimplemented_cb()

    def menuitem_about_cb(self, menuitem):
        self.menuitem_unimplemented_cb()

    def save_file(self, filename, mode):  # needs to be overridden
        self.message('Saving %s!' % filename)

    def open_file(self, filename):  # needs to be overridden
        self.message('Opening %s!' % filename)

    def menuitem_unimplemented_cb(self, menuitem=None):
        self.message('Not implemented yet, sorry')
